/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.reports.inputcontrols;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.common.validations.DateTimeFormatValidationRule;
import com.jaspersoft.jasperserver.dto.common.validations.MandatoryValidationRule;
import com.jaspersoft.jasperserver.dto.common.validations.RangeValidationRule;
import com.jaspersoft.jasperserver.dto.common.validations.RegexpValidationRule;
import com.jaspersoft.jasperserver.dto.common.validations.ValidationRule;
import com.jaspersoft.jasperserver.dto.reports.inputcontrols.InputControlState;
import com.jaspersoft.jasperserver.dto.resources.ClientDataType;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ReportInputControl
implements DeepCloneable<ReportInputControl> {
    private String id;
    private String description;
    private String type;
    private String uri;
    private String label;
    private Boolean mandatory;
    private Boolean readOnly;
    private Boolean visible;
    private List<String> masterDependencies = new ArrayList<String>();
    private List<String> slaveDependencies = new ArrayList<String>();
    private List<ValidationRule> validationRules;
    private InputControlState state;
    private ClientDataType dataType;

    public ReportInputControl(ReportInputControl other) {
        ValueObjectUtils.checkNotNull(other);
        this.id = other.getId();
        this.description = other.getDescription();
        this.type = other.getType();
        this.uri = other.getUri();
        this.label = other.getLabel();
        this.mandatory = other.getMandatory();
        this.readOnly = other.getReadOnly();
        this.visible = other.getVisible();
        this.masterDependencies = ValueObjectUtils.copyOf(other.getMasterDependencies());
        this.slaveDependencies = ValueObjectUtils.copyOf(other.getSlaveDependencies());
        this.validationRules = ValueObjectUtils.copyOf(other.getValidationRules());
        this.state = ValueObjectUtils.copyOf(other.getState());
        this.dataType = ValueObjectUtils.copyOf(other.getDataType());
    }

    public ReportInputControl() {
    }

    public ClientDataType getDataType() {
        return this.dataType;
    }

    public ReportInputControl setDataType(ClientDataType dataType) {
        this.dataType = dataType == null ? null : (ClientDataType)((ClientDataType)((ClientDataType)((ClientDataType)((ClientDataType)((ClientDataType)((ClientDataType)new ClientDataType(dataType).setCreationDate(null)).setDescription(null)).setLabel(null)).setPermissionMask(null)).setUpdateDate(null)).setUri(null)).setVersion(null);
        return this;
    }

    public InputControlState getState() {
        return this.state;
    }

    public ReportInputControl setState(InputControlState state) {
        this.state = state;
        return this;
    }

    public ReportInputControl setMasterDependencies(List<String> masterDependencies) {
        this.masterDependencies = masterDependencies == null ? new ArrayList() : masterDependencies;
        return this;
    }

    public ReportInputControl setSlaveDependencies(List<String> slaveDependencies) {
        this.slaveDependencies = slaveDependencies == null ? new ArrayList() : slaveDependencies;
        return this;
    }

    @XmlElementWrapper(name="validationRules")
    @XmlElements(value={@XmlElement(name="rangeValidationRule", type=RangeValidationRule.class), @XmlElement(name="regexpValidationRule", type=RegexpValidationRule.class), @XmlElement(name="dateTimeFormatValidationRule", type=DateTimeFormatValidationRule.class), @XmlElement(name="mandatoryValidationRule", type=MandatoryValidationRule.class)})
    public List<ValidationRule> getValidationRules() {
        return this.validationRules;
    }

    public ReportInputControl setValidationRules(List<ValidationRule> validationRules) {
        this.validationRules = validationRules;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public ReportInputControl setType(String type) {
        this.type = type;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ReportInputControl setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public ReportInputControl setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public ReportInputControl setLabel(String label) {
        this.label = label;
        return this;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public ReportInputControl setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public ReportInputControl setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public ReportInputControl setVisible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @XmlElementWrapper(name="masterDependencies")
    @XmlElements(value={@XmlElement(name="controlId")})
    public List<String> getMasterDependencies() {
        return this.masterDependencies;
    }

    @XmlElementWrapper(name="slaveDependencies")
    @XmlElements(value={@XmlElement(name="controlId")})
    public List<String> getSlaveDependencies() {
        return this.slaveDependencies;
    }

    public String getId() {
        return this.id;
    }

    public ReportInputControl setId(String id) {
        this.id = id;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReportInputControl)) {
            return false;
        }
        ReportInputControl that = (ReportInputControl)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        if (this.mandatory != null ? !this.mandatory.equals(that.mandatory) : that.mandatory != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.visible != null ? !this.visible.equals(that.visible) : that.visible != null) {
            return false;
        }
        if (!this.masterDependencies.equals(that.masterDependencies)) {
            return false;
        }
        if (!this.slaveDependencies.equals(that.slaveDependencies)) {
            return false;
        }
        if (this.validationRules != null ? !this.validationRules.equals(that.validationRules) : that.validationRules != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(that.state) : that.state != null) {
            return false;
        }
        return this.dataType != null ? this.dataType.equals(that.dataType) : that.dataType == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.mandatory != null ? this.mandatory.hashCode() : 0);
        result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
        result = 31 * result + (this.visible != null ? this.visible.hashCode() : 0);
        result = 31 * result + this.masterDependencies.hashCode();
        result = 31 * result + this.slaveDependencies.hashCode();
        result = 31 * result + (this.validationRules != null ? this.validationRules.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ReportInputControl{id='" + this.id + '\'' + ", description='" + this.description + '\'' + ", type='" + this.type + '\'' + ", uri='" + this.uri + '\'' + ", label='" + this.label + '\'' + ", mandatory=" + this.mandatory + ", readOnly=" + this.readOnly + ", visible=" + this.visible + ", masterDependencies=" + this.masterDependencies + ", slaveDependencies=" + this.slaveDependencies + ", validationRules=" + this.validationRules + ", state=" + this.state + ", dataType=" + this.dataType + '}';
    }

    @Override
    public ReportInputControl deepClone() {
        return new ReportInputControl(this);
    }
}

