/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources;

import com.jaspersoft.jasperserver.dto.resources.AbstractClientDataSourceHolder;
import com.jaspersoft.jasperserver.dto.resources.ClientBundle;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientReference;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableFile;
import com.jaspersoft.jasperserver.dto.resources.SchemaHolder;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

public abstract class BaseSemanticLayerDataSource<T extends BaseSemanticLayerDataSource<T, S>, S>
extends AbstractClientDataSourceHolder<T>
implements ClientReferenceableDataSource,
SchemaHolder<T, S> {
    public static final String SECURITY_FILE_ATTRIBUTE_NAME = "securityFile";
    private ClientReferenceableFile securityFile;
    private List<ClientBundle> bundles;

    public BaseSemanticLayerDataSource(BaseSemanticLayerDataSource other) {
        super(other);
        this.securityFile = ValueObjectUtils.copyOf(other.getSecurityFile());
        this.bundles = ValueObjectUtils.copyOf(other.getBundles());
    }

    public BaseSemanticLayerDataSource() {
    }

    @Override
    @NotNull
    public ClientReferenceableDataSource getDataSource() {
        return super.getDataSource();
    }

    @XmlElements(value={@XmlElement(name="securityFileReference", type=ClientReference.class), @XmlElement(name="securityFile", type=ClientFile.class)})
    public ClientReferenceableFile getSecurityFile() {
        return this.securityFile;
    }

    public T setSecurityFile(ClientReferenceableFile securityFile) {
        this.securityFile = securityFile;
        return (T)this;
    }

    @XmlElementWrapper(name="bundles")
    @XmlElement(name="bundle")
    public List<ClientBundle> getBundles() {
        return this.bundles;
    }

    public T setBundles(List<ClientBundle> bundles) {
        this.bundles = bundles;
        return (T)this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseSemanticLayerDataSource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseSemanticLayerDataSource that = (BaseSemanticLayerDataSource)o;
        if (this.bundles != null ? !this.bundles.equals(that.bundles) : that.bundles != null) {
            return false;
        }
        return !(this.securityFile != null ? !this.securityFile.equals(that.securityFile) : that.securityFile != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.securityFile != null ? this.securityFile.hashCode() : 0);
        result = 31 * result + (this.bundles != null ? this.bundles.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "AbstractSemanticLayerDataSource{securityFile=" + this.securityFile + ", bundles=" + this.bundles + "} " + super.toString();
    }
}

