/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationElement;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationSingleElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceSingleElement;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

public class ClientAdhocDataViewSchema
implements DeepCloneable<ClientAdhocDataViewSchema>,
Serializable {
    private List<ResourceElement> resources;
    private List<PresentationElement> presentation;

    public ClientAdhocDataViewSchema() {
    }

    public ClientAdhocDataViewSchema(ClientAdhocDataViewSchema source) {
        ValueObjectUtils.checkNotNull(source);
        this.presentation = ValueObjectUtils.copyOf(source.getPresentation());
        this.resources = ValueObjectUtils.copyOf(source.getResources());
    }

    @Override
    public ClientAdhocDataViewSchema deepClone() {
        return new ClientAdhocDataViewSchema(this);
    }

    @XmlElementWrapper(name="resources")
    @XmlElements(value={@XmlElement(name="group", type=ResourceGroupElement.class), @XmlElement(name="element", type=ResourceSingleElement.class)})
    public List<ResourceElement> getResources() {
        return this.resources;
    }

    public ClientAdhocDataViewSchema setResources(List<ResourceElement> resources) {
        this.resources = resources;
        return this;
    }

    @XmlElementWrapper(name="presentation")
    @XmlElements(value={@XmlElement(name="group", type=PresentationGroupElement.class), @XmlElement(name="element", type=PresentationSingleElement.class)})
    public List<PresentationElement> getPresentation() {
        return this.presentation;
    }

    public ClientAdhocDataViewSchema setPresentation(List<PresentationElement> presentation) {
        this.presentation = presentation;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientAdhocDataViewSchema)) {
            return false;
        }
        ClientAdhocDataViewSchema schema = (ClientAdhocDataViewSchema)o;
        if (this.presentation != null ? !this.presentation.equals(schema.presentation) : schema.presentation != null) {
            return false;
        }
        return ValueObjectUtils.equalGroupElements(this.resources, schema.resources);
    }

    public int hashCode() {
        int result = this.resources != null ? ValueObjectUtils.sortResourceGroupElement(this.resources).hashCode() : 0;
        result = 31 * result + (this.presentation != null ? this.presentation.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientAdhocDataViewSchema{resources=" + this.resources + ", presentation=" + this.presentation + '}';
    }
}

