/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources;

import com.jaspersoft.jasperserver.dto.adhoc.query.validation.groups.QueryExecutionValidationGroup;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.dto.resources.ClientReference;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableFile;
import com.jaspersoft.jasperserver.dto.resources.ClientResource;
import com.jaspersoft.jasperserver.dto.resources.FilesMapXmlAdapter;
import com.jaspersoft.jasperserver.dto.resources.validation.ValidResourceReferences;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="customDataSource")
public class ClientCustomDataSource
extends ClientResource<ClientCustomDataSource>
implements ClientReferenceableDataSource {
    private String serviceClass;
    private String dataSourceName;
    private List<ClientProperty> properties;
    @ValidResourceReferences(groups={QueryExecutionValidationGroup.class})
    private Map<String, ClientReferenceableFile> resources;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public ClientCustomDataSource() {
    }

    public ClientCustomDataSource(ClientCustomDataSource source) {
        super(source);
        this.serviceClass = source.getServiceClass();
        this.dataSourceName = source.getDataSourceName();
        this.properties = ValueObjectUtils.copyOf(source.getProperties());
        this.resources = ValueObjectUtils.copyOf(source.getResources());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientCustomDataSource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientCustomDataSource that = (ClientCustomDataSource)o;
        if (this.dataSourceName != null ? !this.dataSourceName.equals(that.dataSourceName) : that.dataSourceName != null) {
            return false;
        }
        if (this.properties != null ? that.properties == null || !new HashSet<ClientProperty>(this.properties).equals(new HashSet<ClientProperty>(that.properties)) : that.properties != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        return !(this.serviceClass != null ? !this.serviceClass.equals(that.serviceClass) : that.serviceClass != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.serviceClass != null ? this.serviceClass.hashCode() : 0);
        result = 31 * result + (this.dataSourceName != null ? this.dataSourceName.hashCode() : 0);
        result = 31 * result + (this.properties != null ? new HashSet<ClientProperty>(this.properties).hashCode() : 0);
        result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
        return result;
    }

    @XmlJavaTypeAdapter(value=FilesMapXmlAdapter.class)
    @XmlElement(name="resources")
    public Map<String, ClientReferenceableFile> getResources() {
        return this.resources;
    }

    public ClientCustomDataSource setResources(Map<String, ClientReferenceableFile> resources) {
        this.resources = resources;
        return this;
    }

    public ClientCustomDataSource setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
        return this;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public ClientCustomDataSource setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
        return this;
    }

    public List<ClientProperty> getProperties() {
        return this.properties;
    }

    public ClientCustomDataSource setProperties(List<ClientProperty> properties) {
        String prefix = "repo:";
        this.properties = properties;
        if (properties != null) {
            for (ClientProperty property : properties) {
                if (!property.getKey().equals("fileName")) continue;
                String value = property.getValue();
                if (property.getValue() == null || !property.getValue().startsWith(prefix)) continue;
                HashMap<String, ClientReferenceableFile> sourceResources = new HashMap<String, ClientReferenceableFile>();
                String uri = value.substring(prefix.length());
                sourceResources.put("dataFile", new ClientReference(uri));
                this.setResources(sourceResources);
            }
        }
        return this;
    }

    public String toString() {
        return "ClientCustomDataSource{serviceClass='" + this.serviceClass + '\'' + ", dataSourceName='" + this.dataSourceName + '\'' + ", properties=" + this.properties + ", resources=" + this.resources + '}';
    }

    public ClientCustomDataSource deepClone() {
        return new ClientCustomDataSource(this);
    }
}

