/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.resources.ClientDashboardFoundation;
import com.jaspersoft.jasperserver.dto.resources.ClientDashboardResource;
import com.jaspersoft.jasperserver.dto.resources.ClientResource;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="dashboard")
public class ClientDashboard
extends ClientResource<ClientDashboard>
implements DeepCloneable<ClientDashboard> {
    private List<ClientDashboardFoundation> foundations;
    private List<ClientDashboardResource> resources;
    private String defaultFoundation;

    public ClientDashboard() {
    }

    public ClientDashboard(ClientDashboard other) {
        super(other);
        this.foundations = ValueObjectUtils.copyOf(other.foundations);
        this.resources = ValueObjectUtils.copyOf(other.resources);
        this.defaultFoundation = other.defaultFoundation;
    }

    public List<ClientDashboardFoundation> getFoundations() {
        return this.foundations;
    }

    public ClientDashboard setFoundations(List<ClientDashboardFoundation> foundations) {
        this.foundations = foundations;
        return this;
    }

    public List<ClientDashboardResource> getResources() {
        return this.resources;
    }

    public String getDefaultFoundation() {
        return this.defaultFoundation;
    }

    public ClientDashboard setDefaultFoundation(String defaultFoundation) {
        this.defaultFoundation = defaultFoundation;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientDashboard that = (ClientDashboard)o;
        if (this.defaultFoundation != null ? !this.defaultFoundation.equals(that.defaultFoundation) : that.defaultFoundation != null) {
            return false;
        }
        if (this.foundations != null ? !this.foundations.equals(that.foundations) : that.foundations != null) {
            return false;
        }
        return !(this.resources != null ? !this.resources.equals(that.resources) : that.resources != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.foundations != null ? this.foundations.hashCode() : 0);
        result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
        result = 31 * result + (this.defaultFoundation != null ? this.defaultFoundation.hashCode() : 0);
        return result;
    }

    public ClientDashboard setResources(List<ClientDashboardResource> resources) {
        this.resources = resources;
        return this;
    }

    public String toString() {
        return "ClientDashboard{version=" + this.getVersion() + ", permissionMask=" + this.getPermissionMask() + ", uri='" + this.getUri() + '\'' + ", label='" + this.getLabel() + '\'' + '}';
    }

    @Override
    public ClientDashboard deepClone() {
        return new ClientDashboard(this);
    }
}

