/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources;

import com.jaspersoft.jasperserver.dto.resources.ClientDataType;
import com.jaspersoft.jasperserver.dto.resources.ClientListOfValues;
import com.jaspersoft.jasperserver.dto.resources.ClientQuery;
import com.jaspersoft.jasperserver.dto.resources.ClientReference;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableDataType;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableInputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableListOfValues;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableQuery;
import com.jaspersoft.jasperserver.dto.resources.ClientResource;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="inputControl")
public class ClientInputControl
extends ClientResource<ClientInputControl>
implements ClientReferenceableInputControl {
    private boolean mandatory;
    private boolean readOnly;
    private boolean visible;
    private byte type;
    private List<String> visibleColumns;
    private String valueColumn;
    private ClientReferenceableDataType dataType;
    private ClientReferenceableQuery query;
    private ClientReferenceableListOfValues listOfValues;

    public ClientInputControl(ClientInputControl other) {
        super(other);
        this.mandatory = other.isMandatory();
        this.readOnly = other.isReadOnly();
        this.visible = other.isVisible();
        this.type = other.getType();
        this.visibleColumns = ValueObjectUtils.copyOf(other.getVisibleColumns());
        this.valueColumn = other.getValueColumn();
        this.dataType = ValueObjectUtils.copyOf(other.getDataType());
        this.query = ValueObjectUtils.copyOf(other.getQuery());
        this.listOfValues = ValueObjectUtils.copyOf(other.getListOfValues());
    }

    public ClientInputControl() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientInputControl that = (ClientInputControl)o;
        if (this.mandatory != that.mandatory) {
            return false;
        }
        if (this.readOnly != that.readOnly) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.visible != that.visible) {
            return false;
        }
        if (this.dataType != null ? !this.dataType.equals(that.dataType) : that.dataType != null) {
            return false;
        }
        if (this.listOfValues != null ? !this.listOfValues.equals(that.listOfValues) : that.listOfValues != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(that.query) : that.query != null) {
            return false;
        }
        if (this.valueColumn != null ? !this.valueColumn.equals(that.valueColumn) : that.valueColumn != null) {
            return false;
        }
        return !(this.visibleColumns != null ? !this.visibleColumns.equals(that.visibleColumns) : that.visibleColumns != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.mandatory ? 1 : 0);
        result = 31 * result + (this.readOnly ? 1 : 0);
        result = 31 * result + (this.visible ? 1 : 0);
        result = 31 * result + this.type;
        result = 31 * result + (this.visibleColumns != null ? this.visibleColumns.hashCode() : 0);
        result = 31 * result + (this.valueColumn != null ? this.valueColumn.hashCode() : 0);
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        result = 31 * result + (this.listOfValues != null ? this.listOfValues.hashCode() : 0);
        return result;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public ClientInputControl setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public ClientInputControl setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public ClientInputControl setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public byte getType() {
        return this.type;
    }

    public ClientInputControl setType(byte type) {
        this.type = type;
        return this;
    }

    @XmlElementWrapper(name="visibleColumns")
    @XmlElement(name="visibleColumn")
    public List<String> getVisibleColumns() {
        return this.visibleColumns;
    }

    public ClientInputControl setVisibleColumns(List<String> visibleColumns) {
        this.visibleColumns = visibleColumns;
        return this;
    }

    public String getValueColumn() {
        return this.valueColumn;
    }

    public ClientInputControl setValueColumn(String valueColumn) {
        this.valueColumn = valueColumn;
        return this;
    }

    @XmlElements(value={@XmlElement(type=ClientReference.class, name="dataTypeReference"), @XmlElement(type=ClientDataType.class, name="dataType")})
    public ClientReferenceableDataType getDataType() {
        return this.dataType;
    }

    public ClientInputControl setDataType(ClientReferenceableDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @XmlElements(value={@XmlElement(type=ClientReference.class, name="queryReference"), @XmlElement(type=ClientQuery.class, name="query")})
    public ClientReferenceableQuery getQuery() {
        return this.query;
    }

    public ClientInputControl setQuery(ClientReferenceableQuery query) {
        this.query = query;
        return this;
    }

    @XmlElements(value={@XmlElement(type=ClientReference.class, name="listOfValuesReference"), @XmlElement(type=ClientListOfValues.class, name="listOfValues")})
    public ClientReferenceableListOfValues getListOfValues() {
        return this.listOfValues;
    }

    public ClientInputControl setListOfValues(ClientReferenceableListOfValues listOfValues) {
        this.listOfValues = listOfValues;
        return this;
    }

    public String toString() {
        return "ClientInputControl{mandatory=" + this.mandatory + ", readOnly=" + this.readOnly + ", visible=" + this.visible + ", type=" + this.type + ", visibleColumns=" + this.visibleColumns + ", valueColumn='" + this.valueColumn + '\'' + ", dataType=" + this.dataType + ", query=" + this.query + ", listOfValues=" + this.listOfValues + ", version=" + this.getVersion() + ", permissionMask=" + this.getPermissionMask() + ", uri='" + this.getUri() + '\'' + ", label='" + this.getLabel() + '\'' + '}';
    }

    public ClientInputControl deepClone() {
        return new ClientInputControl(this);
    }
}

