/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources;

import com.jaspersoft.jasperserver.dto.reports.ReportParameter;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceable;
import com.jaspersoft.jasperserver.dto.resources.ClientResource;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="reportOptions")
public class ClientReportOptions
extends ClientResource<ClientReportOptions>
implements ClientReferenceable {
    private String reportUri;
    private List<ReportParameter> reportParameters;

    public ClientReportOptions() {
    }

    public ClientReportOptions(ClientReportOptions other) {
        super(other);
        this.reportUri = other.reportUri;
        this.reportParameters = ValueObjectUtils.copyOf(other.getReportParameters());
    }

    public String getReportUri() {
        return this.reportUri;
    }

    public ClientReportOptions setReportUri(String reportUri) {
        this.reportUri = reportUri;
        return this;
    }

    @XmlElementWrapper(name="reportParameters")
    @XmlElement(name="reportParameter")
    public List<ReportParameter> getReportParameters() {
        return this.reportParameters;
    }

    public ClientReportOptions setReportParameters(List<ReportParameter> reportParameters) {
        this.reportParameters = reportParameters;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientReportOptions that = (ClientReportOptions)o;
        if (this.reportParameters != null && that.reportParameters == null || this.reportParameters == null && that.reportParameters != null) {
            return false;
        }
        if (this.reportParameters != null && that.reportParameters != null) {
            HashSet<ReportParameter> set1 = new HashSet<ReportParameter>();
            set1.addAll(this.reportParameters);
            HashSet<ReportParameter> set2 = new HashSet<ReportParameter>();
            set2.addAll(that.reportParameters);
            if (!set1.equals(set2)) {
                return false;
            }
        }
        return !(this.reportUri != null ? !this.reportUri.equals(that.reportUri) : that.reportUri != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.reportUri != null ? this.reportUri.hashCode() : 0);
        result = 31 * result + (this.reportParameters != null ? this.reportParameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientReportOptions{reportUri='" + this.reportUri + '\'' + ", reportParameters=" + this.reportParameters + ", version=" + this.getVersion() + ", permissionMask=" + this.getPermissionMask() + ", uri='" + this.getUri() + '\'' + ", label='" + this.getLabel() + '\'' + '}';
    }

    public ClientReportOptions deepClone() {
        return new ClientReportOptions(this);
    }
}

