/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="dataSourceTableDescriptor")
public class DataSourceTableDescriptor
implements DeepCloneable<DataSourceTableDescriptor> {
    private String datasourceTableName;
    private String schemaName;

    public DataSourceTableDescriptor() {
    }

    public DataSourceTableDescriptor(DataSourceTableDescriptor source) {
        ValueObjectUtils.checkNotNull(source);
        this.schemaName = ValueObjectUtils.copyOf(source.getSchemaName());
        this.datasourceTableName = ValueObjectUtils.copyOf(source.getDatasourceTableName());
    }

    @XmlElement(name="schemaName")
    public String getSchemaName() {
        return this.schemaName;
    }

    public DataSourceTableDescriptor setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    @XmlElement(name="datasourceTableName")
    public String getDatasourceTableName() {
        return this.datasourceTableName;
    }

    public DataSourceTableDescriptor setDatasourceTableName(String datasourceTableName) {
        this.datasourceTableName = datasourceTableName;
        return this;
    }

    @Override
    public DataSourceTableDescriptor deepClone() {
        return new DataSourceTableDescriptor(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceTableDescriptor that = (DataSourceTableDescriptor)o;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.datasourceTableName, that.datasourceTableName);
    }

    public int hashCode() {
        int result = this.schemaName != null ? this.schemaName.hashCode() : 0;
        result = 31 * result + (this.datasourceTableName != null ? this.datasourceTableName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DataSourceTableDescriptor{schemaName=" + this.schemaName + ", datasourceTableName=" + this.datasourceTableName + '}';
    }
}

