/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.domain;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpressionContainer;
import com.jaspersoft.jasperserver.dto.resources.domain.GroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.QueryResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ReferenceElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceMetadataSingleElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceSingleElement;
import com.jaspersoft.jasperserver.dto.resources.domain.SchemaElement;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

public abstract class AbstractResourceGroupElement<T extends AbstractResourceGroupElement<T>>
extends ResourceElement<T>
implements GroupElement<SchemaElement, T> {
    @Valid
    private List<SchemaElement> elements;
    @Valid
    private ClientExpressionContainer filterExpression;

    public AbstractResourceGroupElement() {
    }

    public AbstractResourceGroupElement(AbstractResourceGroupElement<T> source) {
        super(source);
        this.elements = ValueObjectUtils.copyOf(source.getElements());
        this.filterExpression = ValueObjectUtils.copyOf(source.getFilterExpression());
    }

    @Override
    @XmlElementWrapper(name="elements")
    @XmlElements(value={@XmlElement(name="reference", type=ReferenceElement.class), @XmlElement(name="group", type=ResourceGroupElement.class), @XmlElement(name="queryGroup", type=QueryResourceGroupElement.class), @XmlElement(name="element", type=ResourceMetadataSingleElement.class), @XmlElement(name="element", type=ResourceSingleElement.class)})
    public List<SchemaElement> getElements() {
        return this.elements;
    }

    @Override
    public T setElements(List<SchemaElement> elements) {
        this.elements = elements;
        return (T)this;
    }

    public ClientExpressionContainer getFilterExpression() {
        return this.filterExpression;
    }

    public T setFilterExpression(ClientExpressionContainer filterExpression) {
        this.filterExpression = filterExpression;
        return (T)this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractResourceGroupElement)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractResourceGroupElement that = (AbstractResourceGroupElement)o;
        if (this.elements != null ? !this.elements.equals(that.elements) : that.elements != null) {
            return false;
        }
        return !(this.filterExpression != null ? !this.filterExpression.equals(that.filterExpression) : that.filterExpression != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.elements != null ? this.elements.hashCode() : 0);
        result = 31 * result + (this.filterExpression != null ? this.filterExpression.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "AbstractResourceGroupElement{elements=" + this.elements + ", filterExpression='" + this.filterExpression + '\'' + "} " + super.toString();
    }
}

