/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.domain;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.resources.ClientResource;
import com.jaspersoft.jasperserver.dto.resources.domain.ConstantsResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.JoinResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.QueryResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceSingleElement;
import com.jaspersoft.jasperserver.dto.resources.domain.Schema;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="domainSchema")
public class ClientDomainSchema
extends ClientResource<ClientDomainSchema>
implements DeepCloneable<ClientDomainSchema> {
    @Valid
    private final Schema schema;

    public ClientDomainSchema() {
        this.schema = new Schema();
    }

    public ClientDomainSchema(Schema schema) {
        this.schema = schema != null ? new Schema(schema) : new Schema();
    }

    public ClientDomainSchema(ClientDomainSchema source) {
        super(source);
        this.schema = ValueObjectUtils.copyOf(source.getSchema());
    }

    @Override
    public ClientDomainSchema deepClone() {
        return new ClientDomainSchema(this);
    }

    @XmlTransient
    public Schema getSchema() {
        return this.schema;
    }

    public ClientDomainSchema setSchema(Schema schema) {
        this.schema.setPresentation(schema != null ? schema.getPresentation() : null);
        this.schema.setResources(schema != null ? schema.getResources() : null);
        return this;
    }

    @XmlElementWrapper(name="resources")
    @XmlElements(value={@XmlElement(name="group", type=ResourceGroupElement.class), @XmlElement(name="queryGroup", type=QueryResourceGroupElement.class), @XmlElement(name="element", type=ResourceSingleElement.class), @XmlElement(name="constantsGroup", type=ConstantsResourceGroupElement.class), @XmlElement(name="joinGroup", type=JoinResourceGroupElement.class)})
    public List<ResourceElement> getResources() {
        return this.schema.getResources();
    }

    public ClientDomainSchema setResources(List<ResourceElement> resources) {
        this.schema.setResources(resources);
        return this;
    }

    @XmlElementWrapper(name="presentation")
    @XmlElement(name="dataIsland")
    public List<PresentationGroupElement> getPresentation() {
        return this.schema.getPresentation();
    }

    public ClientDomainSchema setPresentation(List<PresentationGroupElement> presentation) {
        this.schema.setPresentation(presentation);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientDomainSchema)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientDomainSchema that = (ClientDomainSchema)o;
        return !(this.schema != null ? !this.schema.equals(that.schema) : that.schema != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientDomainSchema{schema=" + this.schema + "} " + super.toString();
    }
}

