/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.domain;

import com.jaspersoft.jasperserver.dto.resources.domain.AbstractResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ConstantsResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.JoinResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationElement;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationSingleElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ReferenceElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceElement;
import com.jaspersoft.jasperserver.dto.resources.domain.SchemaElement;
import java.util.ArrayList;
import java.util.List;

public class DomainSchemaHelper {
    public static <T extends SchemaElement> T findResourceElement(String resourcePath, List<ResourceElement> resources) {
        SchemaElement result = null;
        List<SchemaElement> currentElements = resources;
        if (resources != null && resourcePath != null) {
            String[] pathTokens = resourcePath.split("\\.");
            for (int i = 0; i < pathTokens.length; ++i) {
                String name = pathTokens[i];
                SchemaElement currentResult = null;
                if (currentElements == null) break;
                for (SchemaElement schemaElement : currentElements) {
                    if (schemaElement == null || !name.equals(schemaElement.getName())) continue;
                    currentResult = schemaElement;
                    break;
                }
                if (i == pathTokens.length - 1) {
                    result = currentResult;
                    continue;
                }
                if (currentResult instanceof AbstractResourceGroupElement) {
                    currentElements = ((AbstractResourceGroupElement)currentResult).getElements();
                    continue;
                }
                if (currentResult instanceof ConstantsResourceGroupElement) {
                    currentElements = ((ConstantsResourceGroupElement)currentResult).getElements();
                    continue;
                }
                if (!(currentResult instanceof ReferenceElement)) break;
                T referenced = DomainSchemaHelper.findResourceElement(((ReferenceElement)currentResult).getReferencePath(), resources);
                if (referenced == null || !(referenced instanceof AbstractResourceGroupElement)) continue;
                currentElements = ((AbstractResourceGroupElement)referenced).getElements();
            }
        }
        return (T)result;
    }

    public static String getDataIslandPathFromElement(PresentationSingleElement element, List<ResourceElement> clientResources) {
        String result = null;
        if (element != null && element.getResourcePath() != null) {
            String resourcePath = element.getResourcePath();
            String firstLevelResourcePath = resourcePath.substring(0, resourcePath.indexOf("."));
            result = DomainSchemaHelper.findResourceElement(firstLevelResourcePath, clientResources) instanceof JoinResourceGroupElement ? firstLevelResourcePath : resourcePath.substring(0, resourcePath.lastIndexOf("."));
        }
        return result;
    }

    public static String getDataIslandPathFromGroup(PresentationGroupElement group, List<ResourceElement> clientResources, List<String> constantGroupNames) {
        String result = null;
        if (group != null) {
            List<PresentationElement> elements = group.getElements();
            for (PresentationElement element : elements) {
                String dataIslandPathCandidate;
                if (element instanceof PresentationGroupElement) {
                    result = DomainSchemaHelper.getDataIslandPathFromGroup((PresentationGroupElement)element, clientResources, constantGroupNames);
                } else if (element instanceof PresentationSingleElement && !constantGroupNames.contains(dataIslandPathCandidate = DomainSchemaHelper.getDataIslandPathFromElement((PresentationSingleElement)element, clientResources))) {
                    result = dataIslandPathCandidate;
                }
                if (result == null) continue;
                break;
            }
        }
        if (result == null && !constantGroupNames.isEmpty()) {
            result = DomainSchemaHelper.getDataIslandPathFromGroup(group, clientResources, new ArrayList<String>());
        }
        return result;
    }
}

