/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.domain;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpressionContainer;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.resources.domain.validation.ValidEnumValueOrProfileAttribute;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class Join
implements DeepCloneable<Join>,
Serializable {
    public static final String ERROR_CODE_DOMAIN_SCHEMA_JOIN_TYPE_INVALID = "domain.schema.resources.join.type";
    @NotNull
    private String left;
    @NotNull
    private String right;
    @Valid
    private ClientExpressionContainer expression;
    private Integer weight;
    private String type;

    public Join() {
    }

    public Join(Join source) {
        ValueObjectUtils.checkNotNull(source);
        this.left = source.getLeft();
        this.right = source.getRight();
        this.expression = ValueObjectUtils.copyOf(source.getExpression());
        this.weight = source.getWeight();
        this.type = source.getType();
    }

    public String getLeft() {
        return this.left;
    }

    public Join setLeft(String left) {
        this.left = left;
        return this;
    }

    public String getRight() {
        return this.right;
    }

    public Join setRight(String right) {
        this.right = right;
        return this;
    }

    public ClientExpressionContainer getExpression() {
        return this.expression;
    }

    public Join setExpression(ClientExpressionContainer expression) {
        this.expression = expression;
        return this;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public Join setWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    @ValidEnumValueOrProfileAttribute(enumClass=JoinType.class, message="domain.schema.resources.join.type")
    public String getType() {
        return this.type;
    }

    public Join setType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public Join deepClone() {
        return new Join(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Join)) {
            return false;
        }
        Join join = (Join)o;
        if (this.expression != null ? !this.expression.equals(join.expression) : join.expression != null) {
            return false;
        }
        if (this.left != null ? !this.left.equals(join.left) : join.left != null) {
            return false;
        }
        if (this.right != null ? !this.right.equals(join.right) : join.right != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(join.type) : join.type != null) {
            return false;
        }
        return !(this.weight != null ? !this.weight.equals(join.weight) : join.weight != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Join{left='" + this.left + '\'' + ", right='" + this.right + '\'' + ", expression='" + this.expression + '\'' + ", weight=" + this.weight + ", type=" + this.type + '}';
    }

    public static enum JoinType {
        inner,
        leftOuter,
        rightOuter,
        fullOuter;

    }
}

