/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.domain;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.resources.domain.Join;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class JoinInfo
implements DeepCloneable<JoinInfo>,
Serializable {
    private Boolean includeAllJoinsForQueryFieldTables;
    private Boolean includeAllDataIslandJoins;
    private Boolean suppressCircularJoins;
    @Valid
    private List<Join> joins;
    private List<String> mandatoryTables;

    public JoinInfo() {
    }

    public JoinInfo(JoinInfo source) {
        ValueObjectUtils.checkNotNull(source);
        this.includeAllJoinsForQueryFieldTables = source.getIncludeAllJoinsForQueryFieldTables();
        this.includeAllDataIslandJoins = source.getIncludeAllDataIslandJoins();
        this.suppressCircularJoins = source.getSuppressCircularJoins();
        this.joins = ValueObjectUtils.copyOf(source.getJoins());
        this.mandatoryTables = ValueObjectUtils.copyOf(source.getMandatoryTables());
    }

    @Override
    public JoinInfo deepClone() {
        return new JoinInfo(this);
    }

    public Boolean getIncludeAllJoinsForQueryFieldTables() {
        return this.includeAllJoinsForQueryFieldTables;
    }

    public JoinInfo setIncludeAllJoinsForQueryFieldTables(Boolean includeAllJoinsForQueryFieldTables) {
        this.includeAllJoinsForQueryFieldTables = includeAllJoinsForQueryFieldTables;
        return this;
    }

    public Boolean getIncludeAllDataIslandJoins() {
        return this.includeAllDataIslandJoins;
    }

    public JoinInfo setIncludeAllDataIslandJoins(Boolean includeAllDataIslandJoins) {
        this.includeAllDataIslandJoins = includeAllDataIslandJoins;
        return this;
    }

    public Boolean getSuppressCircularJoins() {
        return this.suppressCircularJoins;
    }

    public JoinInfo setSuppressCircularJoins(Boolean suppressCircularJoins) {
        this.suppressCircularJoins = suppressCircularJoins;
        return this;
    }

    @XmlElementWrapper(name="joins")
    @XmlElement(name="join")
    public List<Join> getJoins() {
        return this.joins;
    }

    public JoinInfo setJoins(List<Join> joins) {
        this.joins = joins;
        return this;
    }

    @XmlElementWrapper(name="mandatoryTables")
    @XmlElement(name="mandatoryTable")
    public List<String> getMandatoryTables() {
        return this.mandatoryTables;
    }

    public JoinInfo setMandatoryTables(List<String> mandatoryTables) {
        this.mandatoryTables = mandatoryTables;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JoinInfo)) {
            return false;
        }
        JoinInfo joinInfo = (JoinInfo)o;
        if (this.includeAllJoinsForQueryFieldTables != null ? !this.includeAllJoinsForQueryFieldTables.equals(joinInfo.includeAllJoinsForQueryFieldTables) : joinInfo.includeAllJoinsForQueryFieldTables != null) {
            return false;
        }
        if (this.includeAllDataIslandJoins != null ? !this.includeAllDataIslandJoins.equals(joinInfo.includeAllDataIslandJoins) : joinInfo.includeAllDataIslandJoins != null) {
            return false;
        }
        if (this.suppressCircularJoins != null ? !this.suppressCircularJoins.equals(joinInfo.suppressCircularJoins) : joinInfo.suppressCircularJoins != null) {
            return false;
        }
        if (this.joins != null ? !this.joins.equals(joinInfo.joins) : joinInfo.joins != null) {
            return false;
        }
        return !(this.mandatoryTables != null ? !this.mandatoryTables.equals(joinInfo.mandatoryTables) : joinInfo.mandatoryTables != null);
    }

    public int hashCode() {
        int result = this.includeAllJoinsForQueryFieldTables != null ? this.includeAllJoinsForQueryFieldTables.hashCode() : 0;
        result = 31 * result + (this.includeAllDataIslandJoins != null ? this.includeAllDataIslandJoins.hashCode() : 0);
        result = 31 * result + (this.suppressCircularJoins != null ? this.suppressCircularJoins.hashCode() : 0);
        result = 31 * result + (this.joins != null ? this.joins.hashCode() : 0);
        result = 31 * result + (this.mandatoryTables != null ? this.mandatoryTables.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JoinInfo{includeAllJoinsForQueryFieldTables=" + this.includeAllJoinsForQueryFieldTables + ", includeAllDataIslandJoins=" + this.includeAllDataIslandJoins + ", suppressCircularJoins=" + this.suppressCircularJoins + ", joins=" + this.joins + ", mandatoryTables=" + this.mandatoryTables + '}';
    }
}

