/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.domain;

import com.jaspersoft.jasperserver.dto.resources.domain.GroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationElement;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationSingleElement;
import com.jaspersoft.jasperserver.dto.resources.domain.validation.NoNullElements;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="group")
public class PresentationGroupElement
extends PresentationElement<PresentationGroupElement>
implements GroupElement<PresentationElement, PresentationGroupElement> {
    public static final String DOMAIN_SCHEMA_PRESENTATION_CONTAINS_NULL_ELEMENT = "domain.schema.presentation.contains.null.element";
    @Valid
    @NoNullElements(errorCode="domain.schema.presentation.contains.null.element", message="Domain schema presentation group can't contain null elements")
    private List<PresentationElement> elements;
    private String kind;

    public PresentationGroupElement() {
    }

    public PresentationGroupElement(PresentationGroupElement source) {
        super(source);
        this.elements = ValueObjectUtils.copyOf(source.getElements());
        this.kind = source.kind;
    }

    @Override
    public PresentationGroupElement deepClone() {
        return new PresentationGroupElement(this);
    }

    @Override
    @XmlElementWrapper(name="elements")
    @XmlElements(value={@XmlElement(name="group", type=PresentationGroupElement.class), @XmlElement(name="element", type=PresentationSingleElement.class)})
    public List<PresentationElement> getElements() {
        return this.elements;
    }

    public String getKind() {
        return this.kind;
    }

    public PresentationGroupElement setKind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public PresentationGroupElement setElements(List<PresentationElement> elements) {
        this.elements = elements;
        return this;
    }

    public PresentationGroupElement addElements(PresentationElement ... elements) {
        List<PresentationElement> presentationElements = Arrays.asList(elements);
        if (this.elements == null) {
            this.elements = presentationElements;
        } else {
            this.elements.addAll(presentationElements);
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PresentationGroupElement that = (PresentationGroupElement)o;
        if (this.elements != null ? !this.elements.equals(that.elements) : that.elements != null) {
            return false;
        }
        return !(this.kind != null ? !this.kind.equals(that.kind) : that.kind != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.elements != null ? this.elements.hashCode() : 0);
        result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "PresentationGroupElement{elements=" + this.elements + ", kind='" + this.kind + '\'' + "} " + super.toString();
    }
}

