/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.domain;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.resources.domain.ConstantsResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.JoinResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.QueryResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceSingleElement;
import com.jaspersoft.jasperserver.dto.resources.domain.validation.NoNullElements;
import com.jaspersoft.jasperserver.dto.resources.domain.validation.ValidReferences;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

@ValidReferences
public class Schema
implements DeepCloneable<Schema>,
Serializable {
    @NotNull
    @Valid
    private List<ResourceElement> resources;
    @NotNull
    @Valid
    @NoNullElements(errorCode="domain.schema.presentation.contains.null.element", message="Domain schema presentation can't contain null elements")
    private List<PresentationGroupElement> presentation;

    public Schema() {
    }

    public Schema(Schema source) {
        ValueObjectUtils.checkNotNull(source);
        this.resources = ValueObjectUtils.copyOf(source.getResources());
        this.presentation = ValueObjectUtils.copyOf(source.getPresentation());
    }

    @Override
    public Schema deepClone() {
        return new Schema(this);
    }

    @XmlElementWrapper(name="resources")
    @XmlElements(value={@XmlElement(name="group", type=ResourceGroupElement.class), @XmlElement(name="queryGroup", type=QueryResourceGroupElement.class), @XmlElement(name="element", type=ResourceSingleElement.class), @XmlElement(name="constantsGroup", type=ConstantsResourceGroupElement.class), @XmlElement(name="joinGroup", type=JoinResourceGroupElement.class)})
    public List<ResourceElement> getResources() {
        return this.resources;
    }

    public Schema setResources(List<ResourceElement> resources) {
        this.resources = resources;
        return this;
    }

    @XmlElementWrapper(name="presentation")
    @XmlElement(name="dataIsland")
    @NotNull
    public List<PresentationGroupElement> getPresentation() {
        return this.presentation;
    }

    public Schema setPresentation(List<PresentationGroupElement> presentation) {
        this.presentation = presentation;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema schema = (Schema)o;
        if (this.presentation != null ? !this.presentation.equals(schema.presentation) : schema.presentation != null) {
            return false;
        }
        if (this.resources != null && schema.resources != null && !ValueObjectUtils.equalGroupElements(this.resources, schema.resources)) {
            return false;
        }
        return (this.resources != null || schema.resources == null) && (this.resources == null || schema.resources != null);
    }

    public int hashCode() {
        int result = this.resources != null ? ValueObjectUtils.sortResourceGroupElement(this.resources).hashCode() : 0;
        result = 31 * result + (this.presentation != null ? this.presentation.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Schema{resources=" + this.resources + ", presentation=" + this.presentation + '}';
    }
}

