/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.domain;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class SchemaElement<T extends SchemaElement<T>>
implements DeepCloneable<T>,
Serializable {
    public static final int ELEMENT_NAME_MAX_LENGTH = 20000;
    private String name;

    public SchemaElement() {
    }

    public SchemaElement(SchemaElement source) {
        ValueObjectUtils.checkNotNull(source);
        this.name = source.getName();
    }

    @NotNull
    @Size(min=1, max=20000, message="domain.schema.presentation.element.name.length.limit")
    public String getName() {
        return this.name;
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaElement)) {
            return false;
        }
        SchemaElement that = (SchemaElement)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return "SchemaElement{name='" + this.name + '\'' + '}';
    }

    @Override
    public T deepClone() {
        SchemaElement instance;
        Class<?> thisClass = this.getClass();
        try {
            Constructor<?> constructor = thisClass.getConstructor(thisClass);
            instance = (SchemaElement)constructor.newInstance(this);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to call cloning constructor of " + thisClass.getName(), e);
        }
        return (T)instance;
    }
}

