/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.domain.validation;

import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ValidationErrorDescriptorBuilder;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.dto.resources.domain.ReferenceElement;
import com.jaspersoft.jasperserver.dto.resources.domain.validation.ConsistentReferenceName;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;

public class ConsistentReferenceNameValidator
implements ConstraintValidator<ConsistentReferenceName, ReferenceElement>,
ValidationErrorDescriptorBuilder {
    public ErrorDescriptor build(ConstraintViolation violation) {
        ReferenceElement invalidValue = (ReferenceElement)violation.getInvalidValue();
        String expectedName = this.getReferencedResourceName(invalidValue.getReferencePath());
        return new ErrorDescriptor().setErrorCode("domain.schema.resources.join.reference.name.inconsistent").setMessage("Reference name should be the same as name of referenced resource. I.e. \"" + expectedName + "\"").addProperties(new ClientProperty("expectedName", expectedName), new ClientProperty("currentName", invalidValue.getName()));
    }

    public void initialize(ConsistentReferenceName constraintAnnotation) {
    }

    public boolean isValid(ReferenceElement value, ConstraintValidatorContext context) {
        boolean result = true;
        String referencePath = value.getReferencePath();
        if (referencePath != null && value.getName() != null) {
            result = value.getName().equals(this.getReferencedResourceName(referencePath));
        }
        return result;
    }

    protected String getReferencedResourceName(String referencePath) {
        return referencePath.substring(referencePath.lastIndexOf(".") + 1);
    }
}

