/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.domain.validation;

import com.jaspersoft.jasperserver.dto.resources.domain.ClientDomain;
import com.jaspersoft.jasperserver.dto.resources.domain.GroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.SchemaElement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DomainJsonPathHelper {
    private static Pattern ROOT_RESOURCES_ELEMENT_PATTERN = Pattern.compile("schema\\.resources\\[(\\d+)\\]");
    private static Pattern ROOT_PRESENTATION_ELEMENT_PATTERN = Pattern.compile("schema\\.presentation\\[(\\d+)\\]");
    private static Pattern ELEMENT_INDEX_PATTERN = Pattern.compile(".elements\\[(\\d+)\\]");

    public static String getResourcePath(ClientDomain domain, String jsonPath) {
        ArrayList resources = domain.getSchema() != null && domain.getSchema().getResources() != null ? domain.getSchema().getResources() : new ArrayList();
        StringBuilder resourcePath = new StringBuilder();
        Matcher matcher = ROOT_RESOURCES_ELEMENT_PATTERN.matcher(jsonPath);
        if (matcher.find()) {
            Integer rootElementIndex = Integer.valueOf(matcher.group(1));
            SchemaElement rootElement = (SchemaElement)resources.get(rootElementIndex);
            List<SchemaElement> elements = rootElement instanceof GroupElement ? ((GroupElement)((Object)rootElement)).getElements() : new ArrayList();
            String elementsPath = DomainJsonPathHelper.getElementsPath(elements, jsonPath);
            resourcePath.append(rootElement.getName());
            if (!elementsPath.isEmpty()) {
                resourcePath.append(".").append(elementsPath);
            }
        } else {
            throw new IllegalArgumentException("JSON Path " + jsonPath + " should start from schema.resources[{rootResourceIndex}]. Where {rootResourceIndex} is a number");
        }
        return resourcePath.toString();
    }

    private static String getElementsPath(List<SchemaElement> schemaElements, String propertyPath) {
        StringBuilder result = new StringBuilder();
        List currentElements = schemaElements;
        Matcher elementIndexMatcher = ELEMENT_INDEX_PATTERN.matcher(propertyPath);
        while (elementIndexMatcher.find()) {
            Integer currentIndex = Integer.valueOf(elementIndexMatcher.group(1));
            SchemaElement currentElement = currentElements.get(currentIndex);
            if (result.length() > 0) {
                result.append(".");
            }
            result.append(currentElement.getName());
            if (!(currentElement instanceof GroupElement)) continue;
            currentElements = ((GroupElement)((Object)currentElement)).getElements();
        }
        return result.toString();
    }

    public static PresentationPath getPresentationPath(ClientDomain domain, String propertyPath) {
        Matcher matcher = ROOT_PRESENTATION_ELEMENT_PATTERN.matcher(propertyPath);
        if (!matcher.find()) {
            throw new IllegalArgumentException("JSON Path " + propertyPath + " should start from schema.presentation[{dataIslandIndex}]. Where {dataIslandIndex} is a number");
        }
        ArrayList presentation = domain.getSchema() != null && domain.getSchema().getPresentation() != null ? domain.getSchema().getPresentation() : new ArrayList();
        Integer dataIslandIndex = Integer.valueOf(matcher.group(1));
        PresentationGroupElement dataIsland = (PresentationGroupElement)presentation.get(dataIslandIndex);
        return new PresentationPath(dataIsland.getName(), DomainJsonPathHelper.getElementsPath(dataIsland.getElements(), propertyPath));
    }

    public static class PresentationPath {
        private String dataIslandName;
        private String hierarchicalName;

        public PresentationPath(String dataIslandName, String hierarchicalName) {
            this.dataIslandName = dataIslandName;
            this.hierarchicalName = hierarchicalName;
        }

        public String getDataIslandName() {
            return this.dataIslandName;
        }

        public PresentationPath setDataIslandName(String dataIslandName) {
            this.dataIslandName = dataIslandName;
            return this;
        }

        public String getHierarchicalName() {
            return this.hierarchicalName;
        }

        public PresentationPath setHierarchicalName(String hierarchicalName) {
            this.hierarchicalName = hierarchicalName;
            return this;
        }
    }
}

