/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.domain.validation;

import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ValidationErrorDescriptorBuilder;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.dto.resources.domain.validation.NotEmpty;
import java.util.Collection;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;

public class NotEmptyValidator
implements ConstraintValidator<NotEmpty, Object>,
ValidationErrorDescriptorBuilder {
    private String errorCode;
    private String message;

    public void initialize(NotEmpty constraintAnnotation) {
        this.errorCode = constraintAnnotation.errorCode();
        this.message = constraintAnnotation.message();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return !((String)value).isEmpty();
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return !((Map)value).isEmpty();
        }
        return false;
    }

    public ErrorDescriptor build(ConstraintViolation violation) {
        ErrorDescriptor errorDescriptor = new ErrorDescriptor().setErrorCode(this.errorCode).setMessage(this.message);
        errorDescriptor.addProperties(new ClientProperty().setKey("propertyPath").setValue(violation.getPropertyPath().toString()));
        return errorDescriptor;
    }
}

