/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.domain.validation;

import com.jaspersoft.jasperserver.dto.bridge.BridgeRegistry;
import com.jaspersoft.jasperserver.dto.bridge.SettingsBridge;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ValidationErrorDescriptorBuilder;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.dto.resources.domain.validation.ValidEnumValueOrProfileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;

public class ValidEnumValueOrProfileAttributeValidator
implements ConstraintValidator<ValidEnumValueOrProfileAttribute, String>,
ValidationErrorDescriptorBuilder {
    private Set<String> enumNames = new HashSet<String>();
    private String errorCode;

    public void initialize(ValidEnumValueOrProfileAttribute constraintAnnotation) {
        ?[] constants = constraintAnnotation.enumClass().getEnumConstants();
        this.errorCode = constraintAnnotation.message();
        if (constants == null) {
            throw new IllegalStateException("enumClass [" + constraintAnnotation.enumClass() + "]is not enum");
        }
        for (Object constant : constants) {
            this.enumNames.add(constant.toString());
        }
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        Pattern pattern = this.getProfileAttributeFunctionPattern();
        return value == null || this.enumNames.contains(value) || pattern == null || pattern.matcher(value).matches();
    }

    protected Pattern getProfileAttributeFunctionPattern() {
        SettingsBridge bridge = BridgeRegistry.getBridge(SettingsBridge.class);
        return bridge != null ? Pattern.compile((String)bridge.getSetting("profileAttributes", "$.attributePlaceholderSimplePattern")) : null;
    }

    public ErrorDescriptor build(ConstraintViolation violation) {
        return new ErrorDescriptor().setErrorCode(this.errorCode).setMessage(violation.getPropertyPath() + " should be one of " + this.enumNames.toString() + " or profile attribute placeholder but is [" + violation.getInvalidValue() + "]").addProperties(new ClientProperty().setKey("propertyPath").setValue(violation.getPropertyPath().toString()), new ClientProperty().setKey("invalidValue").setValue(violation.getInvalidValue().toString()), new ClientProperty().setKey("allowedValues").setValue(this.enumNames.toString()));
    }
}

