/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.domain.validation;

import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ValidationErrorDescriptorBuilder;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.dto.resources.domain.DomainSchemaHelper;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationElement;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.PresentationSingleElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceElement;
import com.jaspersoft.jasperserver.dto.resources.domain.Schema;
import com.jaspersoft.jasperserver.dto.resources.domain.validation.ValidReferences;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;

public class ValidReferencesValidator
implements ConstraintValidator<ValidReferences, Schema>,
ValidationErrorDescriptorBuilder {
    public void initialize(ValidReferences constraintAnnotation) {
    }

    public boolean isValid(Schema value, ConstraintValidatorContext context) {
        return this.findInvalidReferences(value).isEmpty();
    }

    private List<String> findInvalidReferences(Schema schema) {
        ArrayList<String> result = new ArrayList<String>();
        List<PresentationElement> presentation = schema.getPresentation();
        List<ResourceElement> resources = schema.getResources();
        this.fillInvalidReferences(presentation, resources, result);
        return result;
    }

    private void fillInvalidReferences(List<PresentationElement> presentationElements, List<ResourceElement> resources, List<String> invalidReferences) {
        if (presentationElements != null) {
            for (PresentationElement presentationElement : presentationElements) {
                if (presentationElement instanceof PresentationSingleElement) {
                    PresentationSingleElement presentationSingleElement = (PresentationSingleElement)presentationElement;
                    String resourcePath = presentationSingleElement.getResourcePath();
                    if (resourcePath == null || DomainSchemaHelper.findResourceElement(resourcePath, resources) != null) continue;
                    invalidReferences.add(resourcePath);
                    continue;
                }
                if (!(presentationElement instanceof PresentationGroupElement)) continue;
                this.fillInvalidReferences(((PresentationGroupElement)presentationElement).getElements(), resources, invalidReferences);
            }
        }
    }

    public ErrorDescriptor build(ConstraintViolation violation) {
        List<String> invalidReferences = this.findInvalidReferences((Schema)violation.getInvalidValue());
        ErrorDescriptor errorDescriptor = new ErrorDescriptor().setErrorCode("domain.schema.invalid.reference").setMessage("Schema contains invalid references: " + invalidReferences.toString());
        for (String invalidReference : invalidReferences) {
            errorDescriptor.addProperties(new ClientProperty().setKey("invalidReference").setValue(invalidReference));
        }
        return errorDescriptor;
    }
}

