/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources.validation;

import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ValidationErrorDescriptorBuilder;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableFile;
import com.jaspersoft.jasperserver.dto.resources.validation.ValidResourceReferences;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;

public class ResourceReferencesValidator
implements ConstraintValidator<ValidResourceReferences, Map<String, ClientReferenceableFile>>,
ValidationErrorDescriptorBuilder {
    private static final String MANDATORY_PARAMETER = "fileReference.uri";

    public void initialize(ValidResourceReferences constraintAnnotation) {
    }

    public boolean isValid(Map<String, ClientReferenceableFile> value, ConstraintValidatorContext context) {
        return this.findInvalidReferences(value).isEmpty();
    }

    public ErrorDescriptor build(ConstraintViolation violation) {
        List<String> invalidReferences = this.findInvalidReferences((Map)violation.getInvalidValue());
        ErrorDescriptor errorDescriptor = new ErrorDescriptor().setErrorCode("mandatory.parameter.error").setMessage("The mandatory parameter \"fileReference.uri\" is missing.");
        for (String invalidReference : invalidReferences) {
            errorDescriptor.addProperties(new ClientProperty().setKey("invalidReference").setValue("" + violation.getPropertyPath() + "." + invalidReference));
        }
        return errorDescriptor;
    }

    private List<String> findInvalidReferences(Map<String, ClientReferenceableFile> value) {
        ArrayList<String> invalidResources = new ArrayList<String>();
        if (value != null) {
            for (Map.Entry<String, ClientReferenceableFile> entry : value.entrySet()) {
                if (!(entry.getValue() instanceof ClientFile)) continue;
                invalidResources.add("" + entry.getKey() + "." + MANDATORY_PARAMETER);
            }
        }
        return invalidResources;
    }
}

