/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.utils;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;

class CloneOperationsContext {
    private static Map<Class, Executable> cloneOperationsByType = new HashMap<Class, Executable>();

    CloneOperationsContext() {
    }

    <T> Executable<T> operationForClass(Class<T> klass) {
        for (Class c : cloneOperationsByType.keySet()) {
            if (!c.isAssignableFrom(klass)) continue;
            return cloneOperationsByType.get(c);
        }
        return null;
    }

    private static <T> T createInstanceOfClass(Class klass, Class defaultKlass) {
        Object copied;
        try {
            Constructor<Object> defaultConstructor = null;
            Constructor<?>[] publicConstructors = klass.getConstructors();
            if (publicConstructors.length == 0) {
                defaultConstructor = defaultKlass.getConstructor(new Class[0]);
            } else {
                for (Constructor<?> constructor : publicConstructors) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    defaultConstructor = constructor;
                    break;
                }
            }
            copied = defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return copied;
    }

    static {
        cloneOperationsByType.put(DeepCloneable.class, new Executable<DeepCloneable>(){

            @Override
            public DeepCloneable execute(DeepCloneable operand) {
                return operand.deepClone();
            }
        });
        cloneOperationsByType.put(List.class, new Executable<List>(){

            @Override
            public List execute(List operand) {
                List copied = (List)CloneOperationsContext.createInstanceOfClass(operand.getClass(), ArrayList.class);
                for (Object item : operand) {
                    copied.add(ValueObjectUtils.copyOf(item));
                }
                return copied;
            }
        });
        cloneOperationsByType.put(Map.class, new Executable<Map>(){

            @Override
            public Map execute(Map operand) {
                Map copied = (Map)CloneOperationsContext.createInstanceOfClass(operand.getClass(), HashMap.class);
                for (Object key : operand.keySet()) {
                    Object value = operand.get(key);
                    copied.put(key, ValueObjectUtils.copyOf(value));
                }
                return copied;
            }
        });
        cloneOperationsByType.put(Set.class, new Executable<Set>(){

            @Override
            public Set execute(Set operand) {
                Set copied = (Set)CloneOperationsContext.createInstanceOfClass(operand.getClass(), TreeSet.class);
                for (Object item : operand) {
                    copied.add(ValueObjectUtils.copyOf(item));
                }
                return copied;
            }
        });
        cloneOperationsByType.put(Queue.class, new Executable<Queue>(){

            @Override
            public Queue execute(Queue operand) {
                Queue copied = (Queue)CloneOperationsContext.createInstanceOfClass(operand.getClass(), ArrayBlockingQueue.class);
                for (Object item : operand) {
                    copied.add(ValueObjectUtils.copyOf(item));
                }
                return copied;
            }
        });
        cloneOperationsByType.put(Timestamp.class, new Executable<Timestamp>(){

            @Override
            public Timestamp execute(Timestamp operand) {
                return new Timestamp(operand.getTime());
            }
        });
        cloneOperationsByType.put(Date.class, new Executable<Date>(){

            @Override
            public Date execute(Date operand) {
                return (Date)operand.clone();
            }
        });
        cloneOperationsByType.put(TimeZone.class, new Executable<TimeZone>(){

            @Override
            public TimeZone execute(TimeZone operand) {
                return (TimeZone)operand.clone();
            }
        });
        cloneOperationsByType.put(Calendar.class, new Executable<Calendar>(){

            @Override
            public Calendar execute(Calendar operand) {
                return (Calendar)operand.clone();
            }
        });
        cloneOperationsByType.put(boolean[].class, new Executable<boolean[]>(){

            @Override
            public boolean[] execute(boolean[] operand) {
                return Arrays.copyOf(operand, operand.length);
            }
        });
        cloneOperationsByType.put(int[].class, new Executable<int[]>(){

            @Override
            public int[] execute(int[] operand) {
                return Arrays.copyOf(operand, operand.length);
            }
        });
        cloneOperationsByType.put(Object[].class, new Executable<Object[]>(){

            @Override
            public Object[] execute(Object[] operand) {
                if (operand instanceof DeepCloneable[]) {
                    DeepCloneable[] original = (DeepCloneable[])operand;
                    Object[] copied = (DeepCloneable[])Array.newInstance(DeepCloneable.class, original.length);
                    int i = 0;
                    for (DeepCloneable item : original) {
                        copied[i++] = item.deepClone();
                    }
                    return copied;
                }
                return Arrays.copyOf(operand, operand.length);
            }
        });
    }

    static interface Executable<T> {
        public T execute(T var1);
    }
}

