/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.utils;

import com.jaspersoft.jasperserver.dto.resources.domain.AbstractResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.ConstantsResourceGroupElement;
import com.jaspersoft.jasperserver.dto.resources.domain.SchemaElement;
import com.jaspersoft.jasperserver.dto.utils.CloneOperationsContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class ValueObjectUtils {
    private static String NULL_OBJECT_ERROR_MESSAGE = "Null value is not permitted as input value of copy-constructor.";
    private static CloneOperationsContext context = new CloneOperationsContext();

    public static <T> T copyOf(T element) {
        if (element == null) {
            return null;
        }
        CloneOperationsContext.Executable<?> operation = context.operationForClass(element.getClass());
        if (operation == null) {
            return element;
        }
        return (T)operation.execute(element);
    }

    public static boolean equalGroupElements(List<? extends SchemaElement> groupElements1, List<? extends SchemaElement> groupElements2) {
        if (groupElements1 == null && groupElements2 == null) {
            return true;
        }
        if (groupElements1 == null || groupElements2 == null) {
            return false;
        }
        if (groupElements1.size() != groupElements2.size()) {
            return false;
        }
        if (!(groupElements1.get(0) instanceof AbstractResourceGroupElement)) {
            return groupElements1.containsAll(groupElements2);
        }
        ArrayList<? extends SchemaElement> groupElements1Copy = new ArrayList<SchemaElement>(groupElements1);
        ArrayList<? extends SchemaElement> groupElements2Copy = new ArrayList<SchemaElement>(groupElements2);
        Comparator<SchemaElement> comparator = new Comparator<SchemaElement>(){

            @Override
            public int compare(SchemaElement elem1, SchemaElement elem2) {
                if (elem1 != null && elem2 != null) {
                    return ObjectUtils.compare((Comparable)((Object)elem1.getName()), (Comparable)((Object)elem2.getName()));
                }
                if (elem1 == null) {
                    return 1;
                }
                if (elem2 == null) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(groupElements1Copy, comparator);
        Collections.sort(groupElements2Copy, comparator);
        boolean result = true;
        for (int i = 0; i < groupElements1Copy.size(); ++i) {
            SchemaElement resourceElement1 = (SchemaElement)groupElements1Copy.get(i);
            SchemaElement resourceElement2 = (SchemaElement)groupElements2Copy.get(i);
            if (resourceElement1 == null && resourceElement2 == null) {
                result &= true;
                continue;
            }
            if (resourceElement1 != null && resourceElement2 != null && resourceElement1.getName().equals(resourceElement2.getName()) && resourceElement1.getClass() == resourceElement2.getClass()) {
                if (resourceElement1 instanceof AbstractResourceGroupElement) {
                    result &= ValueObjectUtils.equalGroupElements(((AbstractResourceGroupElement)resourceElement1).getElements(), ((AbstractResourceGroupElement)resourceElement2).getElements());
                    continue;
                }
                if (!(resourceElement1 instanceof ConstantsResourceGroupElement)) continue;
                result &= ValueObjectUtils.equalGroupElements(((ConstantsResourceGroupElement)resourceElement1).getElements(), ((ConstantsResourceGroupElement)resourceElement2).getElements());
                continue;
            }
            result &= false;
        }
        return result;
    }

    public static List<? extends SchemaElement> sortResourceGroupElement(List<? extends SchemaElement> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        Comparator<SchemaElement> comparator = new Comparator<SchemaElement>(){

            @Override
            public int compare(SchemaElement elem1, SchemaElement elem2) {
                if (elem1 != null && elem2 != null) {
                    return ObjectUtils.compare((Comparable)((Object)elem1.getName()), (Comparable)((Object)elem2.getName()));
                }
                if (elem1 == null) {
                    return 1;
                }
                if (elem2 == null) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
        if (list.get(0) instanceof AbstractResourceGroupElement || list.get(0) instanceof ConstantsResourceGroupElement) {
            for (SchemaElement schemaElement : list) {
                if (schemaElement instanceof AbstractResourceGroupElement) {
                    ValueObjectUtils.sortResourceGroupElement(((AbstractResourceGroupElement)schemaElement).getElements());
                    continue;
                }
                if (!(schemaElement instanceof ConstantsResourceGroupElement)) continue;
                ValueObjectUtils.sortResourceGroupElement(((ConstantsResourceGroupElement)schemaElement).getElements());
            }
        }
        return list;
    }

    public static <T> boolean isListsOfArraysEquals(List<T[]> first, List<T[]> second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        boolean arraysEquals = true;
        for (int i = 0; i < first.size(); ++i) {
            Object[] firstItem = first.get(i);
            Object[] secondItem = second.get(i);
            arraysEquals = Arrays.equals(firstItem, secondItem);
        }
        return arraysEquals;
    }

    public static <KEY, VALUE> boolean isMapsWithArraysAsValuesEquals(Map<KEY, VALUE[]> first, Map<KEY, VALUE[]> second) {
        if (first == null && second == null) {
            return true;
        }
        if (first != null && second == null || first == null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        if (!first.keySet().containsAll(second.keySet())) {
            return false;
        }
        for (KEY key : first.keySet()) {
            Object[] secondValues;
            Object[] firstValues = first.get(key);
            if (Arrays.equals(firstValues, secondValues = second.get(key))) continue;
            return false;
        }
        return true;
    }

    public static <KEY, VALUE> int hashCodeOfMapWithArraysAsValues(Map<KEY, VALUE[]> map) {
        if (map == null) {
            return 0;
        }
        if (map.size() == 0) {
            return 0;
        }
        int result = 0;
        for (KEY key : map.keySet()) {
            result = 31 * result + Arrays.hashCode(map.get(key));
        }
        return result;
    }

    public static <T> int hashCodeOfListOfArrays(List<T[]> list) {
        if (list == null) {
            return 0;
        }
        if (list.size() == 0) {
            return 0;
        }
        int result = 0;
        for (Object[] objectArray : list) {
            result = 31 * result + Arrays.hashCode(objectArray);
        }
        return result;
    }

    public static void checkNotNull(Object object) {
        ValueObjectUtils.checkNotNull(object, NULL_OBJECT_ERROR_MESSAGE);
    }

    public static void checkNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

