/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.net;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.DefaultSocketFactory;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.StringUtils;
import org.apache.axis.utils.XMLUtils;

public class JSSESocketFactory
extends DefaultSocketFactory
implements SecureSocketFactory {
    private static final String[] BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
    protected SSLSocketFactory sslFactory = null;
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    public JSSESocketFactory(Hashtable attributes) {
        super(attributes);
    }

    protected void initFactory() throws IOException {
        this.sslFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        if (this.sslFactory == null) {
            this.initFactory();
        }
        if (port == -1) {
            port = 443;
        }
        TransportClientProperties tcp = TransportClientPropertiesFactory.create("https");
        boolean hostInNonProxyList = this.isHostInNonProxyList(host, tcp.getNonProxyHosts());
        Socket sslSocket = null;
        if (tcp.getProxyHost().length() == 0 || hostInNonProxyList) {
            sslSocket = this.sslFactory.createSocket(host, port);
        } else {
            int tunnelPort;
            int n = tunnelPort = tcp.getProxyPort().length() != 0 ? Integer.parseInt(tcp.getProxyPort()) : 80;
            if (tunnelPort < 0) {
                tunnelPort = 80;
            }
            Socket tunnel = new Socket(tcp.getProxyHost(), tunnelPort);
            OutputStream tunnelOutputStream = tunnel.getOutputStream();
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(tunnelOutputStream)));
            out.print("CONNECT " + host + ":" + port + " HTTP/1.0\r\n" + "User-Agent: AxisClient");
            if (tcp.getProxyUser().length() != 0 && tcp.getProxyPassword().length() != 0) {
                String encodedPassword = XMLUtils.base64encode((tcp.getProxyUser() + ":" + tcp.getProxyPassword()).getBytes());
                out.print("\nProxy-Authorization: Basic " + encodedPassword);
            }
            out.print("\nContent-Length: 0");
            out.print("\nPragma: no-cache");
            out.print("\r\n\r\n");
            out.flush();
            InputStream tunnelInputStream = tunnel.getInputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("isNull00", "tunnelInputStream", "" + (tunnelInputStream == null)));
            }
            String replyStr = "";
            int newlinesSeen = 0;
            boolean headerDone = false;
            while (newlinesSeen < 2) {
                int i = tunnelInputStream.read();
                if (i < 0) {
                    throw new IOException("Unexpected EOF from proxy");
                }
                if (i == 10) {
                    headerDone = true;
                    ++newlinesSeen;
                    continue;
                }
                if (i == 13) continue;
                newlinesSeen = 0;
                if (headerDone) continue;
                replyStr = replyStr + String.valueOf((char)i);
            }
            if (StringUtils.startsWithIgnoreWhitespaces("HTTP/1.0 200", replyStr) && StringUtils.startsWithIgnoreWhitespaces("HTTP/1.1 200", replyStr)) {
                throw new IOException(Messages.getMessage("cantTunnel00", new String[]{tcp.getProxyHost(), "" + tunnelPort, replyStr}));
            }
            sslSocket = this.sslFactory.createSocket(tunnel, host, port, true);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("setupTunnel00", tcp.getProxyHost(), "" + tunnelPort));
            }
        }
        ((SSLSocket)sslSocket).startHandshake();
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("createdSSL00"));
        }
        JSSESocketFactory.verifyHostName(host, (SSLSocket)sslSocket);
        return sslSocket;
    }

    private static void verifyHostName(String host, SSLSocket ssl) throws IOException {
        if (host == null) {
            throw new IllegalArgumentException("host to verify was null");
        }
        SSLSession session = ssl.getSession();
        if (session == null) {
            InputStream in = ssl.getInputStream();
            in.available();
            session = ssl.getSession();
            if (session == null) {
                ssl.startHandshake();
                session = ssl.getSession();
            }
        }
        Certificate[] certs = session.getPeerCertificates();
        JSSESocketFactory.verifyHostName(host.trim().toLowerCase(Locale.US), (X509Certificate)certs[0]);
    }

    private static void verifyHostName(String host, X509Certificate cert) throws SSLException {
        String[] cns = JSSESocketFactory.getCNs(cert);
        String[] subjectAlts = JSSESocketFactory.getDNSSubjectAlts(cert);
        JSSESocketFactory.verifyHostName(host, cns, subjectAlts);
    }

    private static String[] getDNSSubjectAlts(X509Certificate cert) {
        LinkedList<String> subjectAltList = new LinkedList<String>();
        Collection<List<?>> c = null;
        try {
            c = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException cpe) {
            cpe.printStackTrace();
        }
        if (c != null) {
            Iterator<List<?>> it = c.iterator();
            while (it.hasNext()) {
                List<?> list = it.next();
                int type = (Integer)list.get(0);
                if (type != 2) continue;
                String s = (String)list.get(1);
                subjectAltList.add(s);
            }
        }
        if (!subjectAltList.isEmpty()) {
            String[] subjectAlts = new String[subjectAltList.size()];
            subjectAltList.toArray(subjectAlts);
            return subjectAlts;
        }
        return new String[0];
    }

    private static void verifyHostName(String host, String[] cns, String[] subjectAlts) throws SSLException {
        int i;
        StringBuffer cnTested = new StringBuffer();
        for (i = 0; i < subjectAlts.length; ++i) {
            String name = subjectAlts[i];
            if (name == null) continue;
            if (JSSESocketFactory.verifyHostName(host, name = name.toLowerCase(Locale.US))) {
                return;
            }
            cnTested.append("/").append(name);
        }
        for (i = 0; i < cns.length; ++i) {
            String cn = cns[i];
            if (cn == null) continue;
            if (JSSESocketFactory.verifyHostName(host, cn = cn.toLowerCase(Locale.US))) {
                return;
            }
            cnTested.append("/").append(cn);
        }
        throw new SSLException("hostname in certificate didn't match: <" + host + "> != <" + cnTested + ">");
    }

    private static boolean verifyHostName(String host, String cn) {
        if (JSSESocketFactory.doWildCard(cn) && !JSSESocketFactory.isIPAddress(host)) {
            return JSSESocketFactory.matchesWildCard(cn, host);
        }
        return host.equalsIgnoreCase(cn);
    }

    private static boolean doWildCard(String cn) {
        String[] parts = cn.split("\\.");
        return parts.length >= 3 && parts[0].endsWith("*") && JSSESocketFactory.acceptableCountryWildcard(cn) && !JSSESocketFactory.isIPAddress(cn);
    }

    private static boolean isIPAddress(String hostname) {
        return hostname != null && (IPV4_PATTERN.matcher(hostname).matches() || IPV6_STD_PATTERN.matcher(hostname).matches() || IPV6_HEX_COMPRESSED_PATTERN.matcher(hostname).matches());
    }

    private static boolean acceptableCountryWildcard(String cn) {
        String[] parts = cn.split("\\.");
        if (parts.length > 3 || parts[parts.length - 1].length() != 2) {
            return true;
        }
        String countryCode = parts[parts.length - 2];
        return Arrays.binarySearch(BAD_COUNTRY_2LDS, countryCode) < 0;
    }

    private static boolean matchesWildCard(String cn, String hostName) {
        String[] parts = cn.split("\\.");
        boolean match = false;
        String firstpart = parts[0];
        if (firstpart.length() > 1) {
            String prefix = firstpart.substring(0, firstpart.length() - 1);
            String suffix = cn.substring(firstpart.length());
            String hostSuffix = hostName.substring(prefix.length());
            match = hostName.startsWith(prefix) && hostSuffix.endsWith(suffix);
        } else {
            match = hostName.endsWith(cn.substring(1));
        }
        if (match) {
            match = JSSESocketFactory.countDots(hostName) == JSSESocketFactory.countDots(cn);
        }
        return match;
    }

    private static int countDots(String data) {
        int dots = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) != '.') continue;
            ++dots;
        }
        return dots;
    }

    private static String[] getCNs(X509Certificate cert) {
        String subjectPrincipal = cert.getSubjectX500Principal().toString();
        return JSSESocketFactory.getCNs(subjectPrincipal);
    }

    private static String[] getCNs(String subjectPrincipal) {
        if (subjectPrincipal == null) {
            return null;
        }
        ArrayList<String> cns = new ArrayList<String>();
        try {
            LdapName subjectDN = new LdapName(subjectPrincipal);
            List rdns = subjectDN.getRdns();
            for (int i = rdns.size() - 1; i >= 0; --i) {
                Rdn rds = (Rdn)rdns.get(i);
                Attributes attributes = rds.toAttributes();
                Attribute cn = attributes.get("cn");
                if (cn == null) continue;
                try {
                    Object value = cn.get();
                    if (value == null) continue;
                    cns.add(value.toString());
                    continue;
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return cns.isEmpty() ? null : cns.toArray(new String[cns.size()]);
    }

    static final class Rfc2253Parser {
        private final String name;
        private final char[] chars;
        private final int len;
        private int cur = 0;

        Rfc2253Parser(String name) {
            this.name = name;
            this.len = name.length();
            this.chars = name.toCharArray();
        }

        List parseDn() throws InvalidNameException {
            this.cur = 0;
            ArrayList<Rdn> rdns = new ArrayList<Rdn>(this.len / 3 + 10);
            if (this.len == 0) {
                return rdns;
            }
            rdns.add(this.doParse(new Rdn()));
            while (this.cur < this.len) {
                if (this.chars[this.cur] == ',' || this.chars[this.cur] == ';') {
                    ++this.cur;
                    rdns.add(0, this.doParse(new Rdn()));
                    continue;
                }
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            return rdns;
        }

        Rdn parseRdn() throws InvalidNameException {
            return this.parseRdn(new Rdn());
        }

        Rdn parseRdn(Rdn rdn) throws InvalidNameException {
            rdn = this.doParse(rdn);
            if (this.cur < this.len) {
                throw new InvalidNameException("Invalid RDN: " + this.name);
            }
            return rdn;
        }

        private Rdn doParse(Rdn rdn) throws InvalidNameException {
            while (this.cur < this.len) {
                this.consumeWhitespace();
                String attrType = this.parseAttrType();
                this.consumeWhitespace();
                if (this.cur >= this.len || this.chars[this.cur] != '=') {
                    throw new InvalidNameException("Invalid name: " + this.name);
                }
                ++this.cur;
                this.consumeWhitespace();
                String value = this.parseAttrValue();
                this.consumeWhitespace();
                rdn.put(attrType, Rdn.unescapeValue(value));
                if (this.cur >= this.len || this.chars[this.cur] != '+') break;
                ++this.cur;
            }
            rdn.sort();
            return rdn;
        }

        private String parseAttrType() throws InvalidNameException {
            char c;
            int beg = this.cur;
            while (this.cur < this.len && (Character.isLetterOrDigit(c = this.chars[this.cur]) || c == '.' || c == '-' || c == ' ')) {
                ++this.cur;
            }
            while (this.cur > beg && this.chars[this.cur - 1] == ' ') {
                --this.cur;
            }
            if (beg == this.cur) {
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            return new String(this.chars, beg, this.cur - beg);
        }

        private String parseAttrValue() throws InvalidNameException {
            if (this.cur < this.len && this.chars[this.cur] == '#') {
                return this.parseBinaryAttrValue();
            }
            if (this.cur < this.len && this.chars[this.cur] == '\"') {
                return this.parseQuotedAttrValue();
            }
            return this.parseStringAttrValue();
        }

        private String parseBinaryAttrValue() throws InvalidNameException {
            int beg = this.cur++;
            while (this.cur < this.len && Character.isLetterOrDigit(this.chars[this.cur])) {
                ++this.cur;
            }
            return new String(this.chars, beg, this.cur - beg);
        }

        private String parseQuotedAttrValue() throws InvalidNameException {
            int beg = this.cur++;
            while (this.cur < this.len && this.chars[this.cur] != '\"') {
                if (this.chars[this.cur] == '\\') {
                    ++this.cur;
                }
                ++this.cur;
            }
            if (this.cur >= this.len) {
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            ++this.cur;
            return new String(this.chars, beg, this.cur - beg);
        }

        private String parseStringAttrValue() throws InvalidNameException {
            int end;
            int beg = this.cur;
            int esc = -1;
            while (this.cur < this.len && !this.atTerminator()) {
                if (this.chars[this.cur] == '\\') {
                    esc = ++this.cur;
                }
                ++this.cur;
            }
            if (this.cur > this.len) {
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            for (end = this.cur; end > beg && Rfc2253Parser.isWhitespace(this.chars[end - 1]) && esc != end - 1; --end) {
            }
            return new String(this.chars, beg, end - beg);
        }

        private void consumeWhitespace() {
            while (this.cur < this.len && Rfc2253Parser.isWhitespace(this.chars[this.cur])) {
                ++this.cur;
            }
        }

        private boolean atTerminator() {
            return this.cur < this.len && (this.chars[this.cur] == ',' || this.chars[this.cur] == ';' || this.chars[this.cur] == '+');
        }

        private static boolean isWhitespace(char c) {
            return c == ' ' || c == '\r';
        }
    }

    static class Rdn
    implements Serializable,
    Comparable {
        private transient ArrayList entries;
        private static final int DEFAULT_SIZE = 1;
        private static final long serialVersionUID = -5994465067210009656L;
        private static final String escapees = ",=+<>#;\"\\";

        public Rdn(Attributes attrSet) throws InvalidNameException {
            if (attrSet.size() == 0) {
                throw new InvalidNameException("Attributes cannot be empty");
            }
            this.entries = new ArrayList(attrSet.size());
            NamingEnumeration<? extends Attribute> attrs = attrSet.getAll();
            try {
                int nEntries = 0;
                while (attrs.hasMore()) {
                    RdnEntry entry = new RdnEntry();
                    Attribute attr = attrs.next();
                    entry.type = attr.getID();
                    entry.value = attr.get();
                    this.entries.add(nEntries, entry);
                    ++nEntries;
                }
            }
            catch (NamingException e) {
                InvalidNameException e2 = new InvalidNameException(e.getMessage());
                e2.initCause(e);
                throw e2;
            }
            this.sort();
        }

        public Rdn(String rdnString) throws InvalidNameException {
            this.entries = new ArrayList(1);
            new Rfc2253Parser(rdnString).parseRdn(this);
        }

        public Rdn(Rdn rdn) {
            this.entries = new ArrayList(rdn.entries.size());
            this.entries.addAll(rdn.entries);
        }

        public Rdn(String type, Object value) throws InvalidNameException {
            if (value == null) {
                throw new NullPointerException("Cannot set value to null");
            }
            if (type.equals("") || this.isEmptyValue(value)) {
                throw new InvalidNameException("type or value cannot be empty, type:" + type + " value:" + value);
            }
            this.entries = new ArrayList(1);
            this.put(type, value);
        }

        private boolean isEmptyValue(Object val) {
            return val instanceof String && val.equals("") || val instanceof byte[] && ((byte[])val).length == 0;
        }

        Rdn() {
            this.entries = new ArrayList(1);
        }

        Rdn put(String type, Object value) {
            RdnEntry newEntry = new RdnEntry();
            newEntry.type = type;
            if (value instanceof byte[]) {
                newEntry.value = ((byte[])value).clone();
            } else {
                newEntry.value = value;
            }
            this.entries.add(newEntry);
            return this;
        }

        void sort() {
            if (this.entries.size() > 1) {
                Collections.sort(this.entries);
            }
        }

        public Object getValue() {
            return ((RdnEntry)this.entries.get(0)).getValue();
        }

        public String getType() {
            return ((RdnEntry)this.entries.get(0)).getType();
        }

        public String toString() {
            StringBuffer builder = new StringBuffer();
            int size = this.entries.size();
            if (size > 0) {
                builder.append(this.entries.get(0));
            }
            for (int next = 1; next < size; ++next) {
                builder.append('+');
                builder.append(this.entries.get(next));
            }
            return builder.toString();
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof Rdn)) {
                throw new ClassCastException("The obj is not a Rdn");
            }
            if (obj == this) {
                return 0;
            }
            Rdn that = (Rdn)obj;
            int minSize = Math.min(this.entries.size(), that.entries.size());
            for (int i = 0; i < minSize; ++i) {
                int diff = ((RdnEntry)this.entries.get(i)).compareTo(that.entries.get(i));
                if (diff == 0) continue;
                return diff;
            }
            return this.entries.size() - that.entries.size();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Rdn)) {
                return false;
            }
            Rdn that = (Rdn)obj;
            if (this.entries.size() != that.size()) {
                return false;
            }
            for (int i = 0; i < this.entries.size(); ++i) {
                if (this.entries.get(i).equals(that.entries.get(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.entries.size(); ++i) {
                hash += this.entries.get(i).hashCode();
            }
            return hash;
        }

        public Attributes toAttributes() {
            BasicAttributes attrs = new BasicAttributes(true);
            for (int i = 0; i < this.entries.size(); ++i) {
                RdnEntry entry = (RdnEntry)this.entries.get(i);
                Attribute attr = attrs.put(entry.getType(), entry.getValue());
                if (attr == null) continue;
                attr.add(entry.getValue());
                attrs.put(attr);
            }
            return attrs;
        }

        public int size() {
            return this.entries.size();
        }

        public static String escapeValue(Object val) {
            return val instanceof byte[] ? Rdn.escapeBinaryValue((byte[])val) : Rdn.escapeStringValue((String)val);
        }

        private static String escapeStringValue(String val) {
            int trail;
            int lead;
            char[] chars = val.toCharArray();
            StringBuffer builder = new StringBuffer(2 * val.length());
            for (lead = 0; lead < chars.length && Rdn.isWhitespace(chars[lead]); ++lead) {
            }
            for (trail = chars.length - 1; trail >= 0 && Rdn.isWhitespace(chars[trail]); --trail) {
            }
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (i < lead || i > trail || escapees.indexOf(c) >= 0) {
                    builder.append('\\');
                }
                builder.append(c);
            }
            return builder.toString();
        }

        private static String escapeBinaryValue(byte[] val) {
            StringBuffer builder = new StringBuffer(1 + 2 * val.length);
            builder.append("#");
            for (int i = 0; i < val.length; ++i) {
                byte b = val[i];
                builder.append(Character.forDigit(0xF & b >>> 4, 16));
                builder.append(Character.forDigit(0xF & b, 16));
            }
            return builder.toString();
        }

        public static Object unescapeValue(String val) {
            int beg;
            char[] chars = val.toCharArray();
            int end = chars.length;
            for (beg = 0; beg < end && Rdn.isWhitespace(chars[beg]); ++beg) {
            }
            while (beg < end && Rdn.isWhitespace(chars[end - 1])) {
                --end;
            }
            if (end != chars.length && beg < end && chars[end - 1] == '\\') {
                ++end;
            }
            if (beg >= end) {
                return "";
            }
            if (chars[beg] == '#') {
                return Rdn.decodeHexPairs(chars, ++beg, end);
            }
            if (chars[beg] == '\"' && chars[end - 1] == '\"') {
                ++beg;
                --end;
            }
            StringBuffer builder = new StringBuffer(end - beg);
            int esc = -1;
            for (int i = beg; i < end; ++i) {
                if (chars[i] == '\\' && i + 1 < end) {
                    if (!Character.isLetterOrDigit(chars[i + 1])) {
                        builder.append(chars[++i]);
                        esc = i;
                        continue;
                    }
                    byte[] utf8 = Rdn.getUtf8Octets(chars, i, end);
                    if (utf8.length > 0) {
                        try {
                            builder.append(new String(utf8, "UTF8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        i += utf8.length * 3 - 1;
                        continue;
                    }
                    throw new IllegalArgumentException("Not a valid attribute string value:" + val + ",improper usage of backslash");
                }
                builder.append(chars[i]);
            }
            int len = builder.length();
            if (Rdn.isWhitespace(builder.charAt(len - 1)) && esc != end - 1) {
                builder.setLength(len - 1);
            }
            return builder.toString();
        }

        private static byte[] decodeHexPairs(char[] chars, int beg, int end) {
            byte[] bytes = new byte[(end - beg) / 2];
            int i = 0;
            while (beg + 1 < end) {
                int hi = Character.digit(chars[beg], 16);
                int lo = Character.digit(chars[beg + 1], 16);
                if (hi < 0 || lo < 0) break;
                bytes[i] = (byte)((hi << 4) + lo);
                beg += 2;
                ++i;
            }
            if (beg != end) {
                throw new IllegalArgumentException("Illegal attribute value: " + new String(chars));
            }
            return bytes;
        }

        private static byte[] getUtf8Octets(char[] chars, int beg, int end) {
            byte[] utf8 = new byte[(end - beg) / 3];
            int len = 0;
            while (beg + 2 < end && chars[beg++] == '\\') {
                int hi = Character.digit(chars[beg++], 16);
                int lo = Character.digit(chars[beg++], 16);
                if (hi < 0 || lo < 0) break;
                utf8[len++] = (byte)((hi << 4) + lo);
            }
            if (len == utf8.length) {
                return utf8;
            }
            byte[] res = new byte[len];
            System.arraycopy(utf8, 0, res, 0, len);
            return res;
        }

        private static boolean isWhitespace(char c) {
            return c == ' ' || c == '\r';
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeObject(this.toString());
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.entries = new ArrayList(1);
            String unparsed = (String)s.readObject();
            try {
                new Rfc2253Parser(unparsed).parseRdn(this);
            }
            catch (InvalidNameException e) {
                throw new StreamCorruptedException("Invalid name: " + unparsed);
            }
        }

        private static class RdnEntry
        implements Comparable {
            private String type;
            private Object value;
            private String comparable = null;

            private RdnEntry() {
            }

            String getType() {
                return this.type;
            }

            Object getValue() {
                return this.value;
            }

            public int compareTo(Object obj) {
                RdnEntry that = (RdnEntry)obj;
                int diff = this.type.toUpperCase().compareTo(that.type.toUpperCase());
                if (diff != 0) {
                    return diff;
                }
                if (this.value.equals(that.value)) {
                    return 0;
                }
                return this.getValueComparable().compareTo(that.getValueComparable());
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof RdnEntry)) {
                    return false;
                }
                RdnEntry that = (RdnEntry)obj;
                return this.type.equalsIgnoreCase(that.type) && this.getValueComparable().equals(that.getValueComparable());
            }

            public int hashCode() {
                return this.type.toUpperCase().hashCode() + this.getValueComparable().hashCode();
            }

            public String toString() {
                return this.type + "=" + Rdn.escapeValue(this.value);
            }

            private String getValueComparable() {
                if (this.comparable != null) {
                    return this.comparable;
                }
                this.comparable = this.value instanceof byte[] ? Rdn.escapeBinaryValue((byte[])this.value) : ((String)this.value).toUpperCase();
                return this.comparable;
            }
        }
    }

    static class LdapName
    implements Name {
        private transient ArrayList rdns;
        private transient String unparsed;
        private static final long serialVersionUID = -1595520034788997356L;

        public LdapName(String name) throws InvalidNameException {
            this.unparsed = name;
            this.parse();
        }

        public LdapName(List rdns) {
            this.rdns = new ArrayList(rdns.size());
            for (int i = 0; i < rdns.size(); ++i) {
                Object obj = rdns.get(i);
                if (!(obj instanceof Rdn)) {
                    throw new IllegalArgumentException("Entry:" + obj + "  not a valid type;list entries must be of type Rdn");
                }
                this.rdns.add(obj);
            }
        }

        private LdapName(String name, ArrayList rdns, int beg, int end) {
            this.unparsed = name;
            List sList = rdns.subList(beg, end);
            this.rdns = new ArrayList(sList);
        }

        public int size() {
            return this.rdns.size();
        }

        public boolean isEmpty() {
            return this.rdns.isEmpty();
        }

        public Enumeration getAll() {
            final Iterator iter = this.rdns.iterator();
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return iter.hasNext();
                }

                public Object nextElement() {
                    return iter.next().toString();
                }
            };
        }

        public String get(int posn) {
            return this.rdns.get(posn).toString();
        }

        public Rdn getRdn(int posn) {
            return (Rdn)this.rdns.get(posn);
        }

        public Name getPrefix(int posn) {
            try {
                return new LdapName(null, this.rdns, 0, posn);
            }
            catch (IllegalArgumentException e) {
                throw new IndexOutOfBoundsException("Posn: " + posn + ", Size: " + this.rdns.size());
            }
        }

        public Name getSuffix(int posn) {
            try {
                return new LdapName(null, this.rdns, posn, this.rdns.size());
            }
            catch (IllegalArgumentException e) {
                throw new IndexOutOfBoundsException("Posn: " + posn + ", Size: " + this.rdns.size());
            }
        }

        public boolean startsWith(Name n) {
            int len2;
            if (n == null) {
                return false;
            }
            int len1 = this.rdns.size();
            return len1 >= (len2 = n.size()) && this.matches(0, len2, n);
        }

        public boolean startsWith(List rdns) {
            int len2;
            if (rdns == null) {
                return false;
            }
            int len1 = this.rdns.size();
            return len1 >= (len2 = rdns.size()) && this.doesListMatch(0, len2, rdns);
        }

        public boolean endsWith(Name n) {
            int len2;
            if (n == null) {
                return false;
            }
            int len1 = this.rdns.size();
            return len1 >= (len2 = n.size()) && this.matches(len1 - len2, len1, n);
        }

        public boolean endsWith(List rdns) {
            int len2;
            if (rdns == null) {
                return false;
            }
            int len1 = this.rdns.size();
            return len1 >= (len2 = rdns.size()) && this.doesListMatch(len1 - len2, len1, rdns);
        }

        private boolean doesListMatch(int beg, int end, List rdns) {
            for (int i = beg; i < end; ++i) {
                if (this.rdns.get(i).equals(rdns.get(i - beg))) continue;
                return false;
            }
            return true;
        }

        private boolean matches(int beg, int end, Name n) {
            if (n instanceof LdapName) {
                LdapName ln = (LdapName)n;
                return this.doesListMatch(beg, end, ln.rdns);
            }
            for (int i = beg; i < end; ++i) {
                Rdn rdn;
                String rdnString = n.get(i - beg);
                try {
                    rdn = new Rfc2253Parser(rdnString).parseRdn();
                }
                catch (InvalidNameException e) {
                    return false;
                }
                if (rdn.equals(this.rdns.get(i))) continue;
                return false;
            }
            return true;
        }

        public Name addAll(Name suffix) throws InvalidNameException {
            return this.addAll(this.size(), suffix);
        }

        public Name addAll(List suffixRdns) {
            return this.addAll(this.size(), suffixRdns);
        }

        public Name addAll(int posn, Name suffix) throws InvalidNameException {
            this.unparsed = null;
            if (suffix instanceof LdapName) {
                LdapName s = (LdapName)suffix;
                this.rdns.addAll(posn, s.rdns);
            } else {
                Enumeration<String> comps = suffix.getAll();
                while (comps.hasMoreElements()) {
                    this.rdns.add(posn++, new Rfc2253Parser(comps.nextElement()).parseRdn());
                }
            }
            return this;
        }

        public Name addAll(int posn, List suffixRdns) {
            this.unparsed = null;
            for (int i = 0; i < suffixRdns.size(); ++i) {
                Object obj = suffixRdns.get(i);
                if (!(obj instanceof Rdn)) {
                    throw new IllegalArgumentException("Entry:" + obj + "  not a valid type;suffix list entries must be of type Rdn");
                }
                this.rdns.add(i + posn, obj);
            }
            return this;
        }

        public Name add(String comp) throws InvalidNameException {
            return this.add(this.size(), comp);
        }

        public Name add(Rdn comp) {
            return this.add(this.size(), comp);
        }

        public Name add(int posn, String comp) throws InvalidNameException {
            Rdn rdn = new Rfc2253Parser(comp).parseRdn();
            this.rdns.add(posn, rdn);
            this.unparsed = null;
            return this;
        }

        public Name add(int posn, Rdn comp) {
            if (comp == null) {
                throw new NullPointerException("Cannot set comp to null");
            }
            this.rdns.add(posn, comp);
            this.unparsed = null;
            return this;
        }

        public Object remove(int posn) throws InvalidNameException {
            this.unparsed = null;
            return this.rdns.remove(posn).toString();
        }

        public List getRdns() {
            return Collections.unmodifiableList(this.rdns);
        }

        public Object clone() {
            return new LdapName(this.unparsed, this.rdns, 0, this.rdns.size());
        }

        public String toString() {
            if (this.unparsed != null) {
                return this.unparsed;
            }
            StringBuffer builder = new StringBuffer();
            int size = this.rdns.size();
            if (size - 1 >= 0) {
                builder.append((Rdn)this.rdns.get(size - 1));
            }
            for (int next = size - 2; next >= 0; --next) {
                builder.append(',');
                builder.append((Rdn)this.rdns.get(next));
            }
            this.unparsed = builder.toString();
            return this.unparsed;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LdapName)) {
                return false;
            }
            LdapName that = (LdapName)obj;
            if (this.rdns.size() != that.rdns.size()) {
                return false;
            }
            if (this.unparsed != null && this.unparsed.equalsIgnoreCase(that.unparsed)) {
                return true;
            }
            for (int i = 0; i < this.rdns.size(); ++i) {
                Rdn rdn2;
                Rdn rdn1 = (Rdn)this.rdns.get(i);
                if (rdn1.equals(rdn2 = (Rdn)that.rdns.get(i))) continue;
                return false;
            }
            return true;
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof LdapName)) {
                throw new ClassCastException("The obj is not a LdapName");
            }
            if (obj == this) {
                return 0;
            }
            LdapName that = (LdapName)obj;
            if (this.unparsed != null && this.unparsed.equalsIgnoreCase(that.unparsed)) {
                return 0;
            }
            int minSize = Math.min(this.rdns.size(), that.rdns.size());
            for (int i = 0; i < minSize; ++i) {
                Rdn rdn2;
                Rdn rdn1 = (Rdn)this.rdns.get(i);
                int diff = rdn1.compareTo(rdn2 = (Rdn)that.rdns.get(i));
                if (diff == 0) continue;
                return diff;
            }
            return this.rdns.size() - that.rdns.size();
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.rdns.size(); ++i) {
                Rdn rdn = (Rdn)this.rdns.get(i);
                hash += rdn.hashCode();
            }
            return hash;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeObject(this.toString());
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.unparsed = (String)s.readObject();
            try {
                this.parse();
            }
            catch (InvalidNameException e) {
                throw new StreamCorruptedException("Invalid name: " + this.unparsed);
            }
        }

        private void parse() throws InvalidNameException {
            this.rdns = (ArrayList)new Rfc2253Parser(this.unparsed).parseDn();
        }
    }
}

