/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser.xbeans;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.xb.xsdschema.LocalElement;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelComplexType;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelElement;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelSimpleType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xmlsoap.schemas.wsdl.DefinitionsDocument;
import org.xmlsoap.schemas.wsdl.TTypes;

public class XmlBeanSerializer
implements Serializer {
    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        if (!(value instanceof XmlObject)) {
            throw new IOException((value != null ? value.getClass().getName() : "null") + " is not an " + XmlObject.class.getName());
        }
        context.setWriteXMLType(null);
        context.startElement(name, attributes);
        XmlCursor xCur = ((XmlObject)value).newCursor();
        if (xCur.toFirstContentToken() == XmlCursor.TokenType.START) {
            do {
                Node n;
                if ((n = xCur.getDomNode()).getNodeType() != 1) continue;
                context.writeDOMElement((Element)n);
            } while (xCur.toNextSibling());
        }
        context.endElement();
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        try {
            if (!XmlObject.class.isAssignableFrom(javaType)) {
                throw new RuntimeException("Invalid Object type is assigned to the XMLBeanSerialization Type: " + javaType);
            }
            SchemaType docType = XmlBeans.typeForClass((Class)javaType);
            this.writeSchemaForDocType(docType, types);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void writeSchemaForDocType(SchemaType docType, Types types) throws Exception {
        QName q;
        SchemaDocument.Schema[] mySchemas = XmlBeanSerializer.findtSchemaDocument(docType);
        XmlObject typeNodeInWSDL = XmlBeanSerializer.getTypeNode(mySchemas, q = docType.getName());
        if (null == typeNodeInWSDL) {
            throw new RuntimeException("Type for object not found in the assigned WSDL file. " + docType.getName() + " schema in: " + docType.getSourceName());
        }
        Node n = typeNodeInWSDL.getDomNode();
        Document doc = types.createElement("element_to_get_document_useless_otherwise").getOwnerDocument();
        Element e = (Element)doc.importNode(n, true);
        try {
            types.writeSchemaElementDecl(q, e);
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
        HashSet dependentTypes = new HashSet();
        this.getAllDependentTypes(typeNodeInWSDL, dependentTypes);
        Iterator it = dependentTypes.iterator();
        while (it.hasNext()) {
            QName nxtType = (QName)it.next();
            Class nxtJavaType = this.q2UserClass(nxtType);
            if (null == nxtJavaType || !(class$org$apache$xmlbeans$XmlObject == null ? XmlBeanSerializer.class$("org.apache.xmlbeans.XmlObject") : class$org$apache$xmlbeans$XmlObject).isAssignableFrom(nxtJavaType)) continue;
            this.writeSchema(nxtJavaType, types);
        }
    }

    private Class q2UserClass(QName qname) {
        SchemaGlobalElement sf;
        SchemaTypeLoader stl = XmlBeans.getContextTypeLoader();
        SchemaType st = stl.findType(qname);
        if (st == null && (sf = stl.findElement(qname)) != null) {
            st = sf.getType();
        }
        if (st != null && !st.isBuiltinType()) {
            return st.getJavaClass();
        }
        return null;
    }

    private void getAllDependentTypes(XmlObject nodeInWSDL, Set dependentTypes) {
        XmlCursor cursor = nodeInWSDL.newCursor();
        if (cursor.toFirstChild()) {
            do {
                this.getAllDependentTypes(cursor.getObject(), dependentTypes);
            } while (cursor.toNextSibling());
        }
        if (nodeInWSDL.schemaType().getName().getLocalPart().equals("localElement")) {
            LocalElement e = (LocalElement)nodeInWSDL;
            if (e.isSetType()) {
                dependentTypes.add(e.getType());
            } else if (e.isSetRef()) {
                dependentTypes.add(e.getRef());
            }
        }
    }

    public static DefinitionsDocument parseWSDL(String wsdlLocation) throws IOException, MalformedURLException, XmlException {
        if (wsdlLocation.indexOf("://") > 2) {
            return XmlBeanSerializer.parseWSDL(new URL(wsdlLocation));
        }
        return XmlBeanSerializer.parseWSDL(new File(wsdlLocation));
    }

    public static DefinitionsDocument parseWSDL(File wsdlFile) throws IOException, XmlException {
        return DefinitionsDocument.Factory.parse((File)wsdlFile);
    }

    public static DefinitionsDocument parseWSDL(URL wsdlURL) throws IOException, XmlException {
        return DefinitionsDocument.Factory.parse((URL)wsdlURL);
    }

    public static DefinitionsDocument parseWSDL(InputStream wsdlStream) throws IOException, XmlException {
        return DefinitionsDocument.Factory.parse((InputStream)wsdlStream);
    }

    public static SchemaDocument parseSchema(InputStream stream) throws XmlException, IOException {
        return SchemaDocument.Factory.parse((InputStream)stream);
    }

    public static SchemaDocument.Schema[] selectChildren(XmlObject parent, Class childClass) throws IllegalAccessException, NoSuchFieldException {
        SchemaType st = (SchemaType)childClass.getField("type").get(null);
        XmlObject[] kids = parent.selectChildren(st.getDocumentElementName());
        SchemaDocument.Schema[] castKids = (SchemaDocument.Schema[])Array.newInstance(childClass, kids.length);
        for (int j = 0; j < castKids.length; ++j) {
            castKids[j] = (SchemaDocument.Schema)kids[j];
        }
        return castKids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SchemaDocument.Schema[] findtSchemaDocument(SchemaType docType) throws XmlException, IOException, IllegalAccessException, NoSuchFieldException {
        SchemaDocument.Schema[] schemas = null;
        String schemaSrc = docType.getSourceName();
        InputStream stream = null;
        try {
            stream = docType.getTypeSystem().getSourceAsStream(schemaSrc);
            if (null == stream) {
                throw new RuntimeException("WSDL file not found: " + schemaSrc);
            }
            if (schemaSrc.toLowerCase().endsWith(".wsdl")) {
                TTypes tt = XmlBeanSerializer.parseWSDL(stream).getDefinitions().getTypesArray(0);
                schemas = XmlBeanSerializer.selectChildren((XmlObject)tt, SchemaDocument.Schema.class);
            } else {
                SchemaDocument schemaDoc = XmlBeanSerializer.parseSchema(stream);
                schemas = new SchemaDocument.Schema[]{schemaDoc.getSchema()};
            }
            Object var6_6 = null;
            if (null == stream) return schemas;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (null == stream) throw throwable;
            stream.close();
            throw throwable;
        }
        stream.close();
        return schemas;
    }

    public static XmlObject getTypeNode(SchemaDocument.Schema[] schemas, QName q) {
        SchemaDocument.Schema schema = null;
        for (int i = 0; i < schemas.length; ++i) {
            SchemaDocument.Schema nxtSchema = schemas[i];
            if (nxtSchema.getTargetNamespace() == null || !nxtSchema.getTargetNamespace().equals(q.getNamespaceURI())) continue;
            schema = nxtSchema;
            break;
        }
        if (null == schema) {
            return null;
        }
        TopLevelComplexType[] tlComplexTypes = schema.getComplexTypeArray();
        for (int i = 0; i < tlComplexTypes.length; ++i) {
            TopLevelComplexType nxtComplexType = tlComplexTypes[i];
            if (!nxtComplexType.getName().equals(q.getLocalPart())) continue;
            return nxtComplexType;
        }
        TopLevelSimpleType[] tlSimpleTypes = schema.getSimpleTypeArray();
        for (int i = 0; i < tlSimpleTypes.length; ++i) {
            TopLevelSimpleType nxtSimpleType = tlSimpleTypes[i];
            if (!nxtSimpleType.getName().equals(q.getLocalPart())) continue;
            return nxtSimpleType;
        }
        TopLevelElement[] tlElementTypes = schema.getElementArray();
        for (int i = 0; i < tlElementTypes.length; ++i) {
            TopLevelElement nxtElement = tlElementTypes[i];
            if (!nxtElement.getName().equals(q.getLocalPart())) continue;
            return nxtElement;
        }
        return null;
    }
}

