/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.rcp.handlers;

import com.jaspersoft.studio.ConfigurationManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;

public class LocaleSourceProvider
extends AbstractSourceProvider {
    public static final String ACTUAL_LOCALE = "actual_locale";
    private static String actualLocale = null;

    public void dispose() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getActualLocale() {
        URL location = null;
        String path = ConfigurationManager.getApplicationConfigurationPath();
        String locale = null;
        try {
            location = new URL(path);
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            String fileName = location.getFile();
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            try {
                String line = in.readLine();
                while (line != null && locale == null) {
                    if (line.equals("-nl")) {
                        locale = in.readLine();
                        continue;
                    }
                    line = in.readLine();
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            locale = Locale.getDefault().toString();
        }
        if (locale != null) return locale;
        return Locale.getDefault().toString();
    }

    public static String getLocale() {
        if (actualLocale == null) {
            actualLocale = LocaleSourceProvider.getActualLocale();
        }
        return actualLocale;
    }

    public void forceRefreshLocale() {
        actualLocale = LocaleSourceProvider.getActualLocale();
    }

    public Map<String, String> getCurrentState() {
        HashMap<String, String> currentState = new HashMap<String, String>(1);
        String locale = LocaleSourceProvider.getLocale();
        currentState.put(ACTUAL_LOCALE, locale);
        return currentState;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{ACTUAL_LOCALE};
    }
}

