/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.rcp.intro;

import com.jaspersoft.studio.rcp.OpenDocumentEventProcessor;
import com.jaspersoft.studio.rcp.intro.ApplicationWorkbenchAdvisor;
import com.jaspersoft.studio.rcp.messages.Messages;
import com.jaspersoft.studio.rcp.workspace.PickWorkspaceDialog;
import com.jaspersoft.studio.rcp.workspace.WorkspaceUtils;
import java.net.URL;
import net.sf.jasperreports.eclipse.util.BundleCommonUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class Application
implements IApplication {
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";

    public Object start(IApplicationContext context) throws Exception {
        OpenDocumentEventProcessor openDocProcessor = new OpenDocumentEventProcessor();
        Display display = PlatformUI.createDisplay();
        display.addListener(46, (Listener)openDocProcessor);
        try {
            int returnCode;
            Location instanceLoc = Platform.getInstanceLocation();
            if (instanceLoc != null) {
                MessageDialog warningDialog;
                boolean isLegacyWS;
                boolean workspaceExists;
                if (!instanceLoc.isSet()) {
                    instanceLoc.set(new URL("file", null, PickWorkspaceDialog.getLastSetWorkspaceDirectory()), false);
                }
                if ((workspaceExists = WorkspaceUtils.checkWorkspaceExists(instanceLoc)) && (isLegacyWS = WorkspaceUtils.isLegacyWorkspace(instanceLoc)) && (warningDialog = WorkspaceUtils.getLegacyWorkspaceWarningDialog(FileLocator.toFileURL((URL)instanceLoc.getURL()).getPath())).open() == 0) {
                    PickWorkspaceDialog pwd = new PickWorkspaceDialog(false, BundleCommonUtils.getImage((String)"com.jaspersoft.studio.rcp", (String)"icons/jss_icon_64.png"), true);
                    int pick = pwd.open();
                    if (pick == 1) {
                        if (pwd.getSelectedWorkspaceLocation() == null) {
                            MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.Application_ErrorTitle, (String)Messages.Application_WorkspaceErrorMsg);
                            try {
                                PlatformUI.getWorkbench().close();
                            }
                            catch (Exception exception) {}
                            System.exit(0);
                            Integer n = IApplication.EXIT_OK;
                            return n;
                        }
                    } else {
                        Integer n = IApplication.EXIT_RESTART;
                        return n;
                    }
                }
            }
            if ((returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor(openDocProcessor))) != 1) {
                Integer n = EXIT_OK;
                return n;
            }
            Integer n = EXIT_RELAUNCH.equals(Integer.getInteger(PROP_EXIT_CODE)) ? EXIT_RELAUNCH : EXIT_RESTART;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

