/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.rcp.intro;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.rcp.OpenDocumentEventProcessor;
import com.jaspersoft.studio.rcp.intro.ApplicationWorkbenchWindowAdvisor;
import com.jaspersoft.studio.rcp.messages.Messages;
import com.jaspersoft.studio.rcp.p2.P2Util;
import com.jaspersoft.studio.utils.BrandingInfo;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import net.sf.jasperreports.eclipse.util.BundleCommonUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private OpenDocumentEventProcessor openDocProcessor;

    public ApplicationWorkbenchAdvisor(OpenDocumentEventProcessor openDocProcessor) {
        this.openDocProcessor = openDocProcessor;
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
        this.declareWorkbenchImages();
        TrayDialog.setDialogHelpAvailable((boolean)true);
        BrandingInfo info = new BrandingInfo();
        info.setProductName(Messages.ApplicationWorkbenchAdvisor_ProductName);
        info.setProductVersion(BundleCommonUtils.getBundleVersion((String)"com.jaspersoft.studio.rcp"));
        info.setProductMainBundleID("com.jaspersoft.studio.rcp");
        JaspersoftStudioPlugin.getInstance().setBrandingInformation(info);
    }

    private void declareWorkbenchImages() {
        Bundle ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC", "$nl$/icons/full/etool16/build_exec.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_HOVER", "$nl$/icons/full/etool16/build_exec.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_DISABLED", "$nl$/icons/full/dtool16/build_exec.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC", "$nl$/icons/full/etool16/search_src.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_HOVER", "$nl$/icons/full/etool16/search_src.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_DISABLED", "$nl$/icons/full/dtool16/search_src.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_NEXT_NAV", "$nl$/icons/full/etool16/next_nav.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PREVIOUS_NAV", "$nl$/icons/full/etool16/prev_nav.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWPRJ_WIZ", "$nl$/icons/full/wizban/newprj_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFOLDER_WIZ", "$nl$/icons/full/wizban/newfolder_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFILE_WIZ", "$nl$/icons/full/wizban/newfile_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTDIR_WIZ", "$nl$/icons/full/wizban/importdir_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTZIP_WIZ", "$nl$/icons/full/wizban/importzip_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTDIR_WIZ", "$nl$/icons/full/wizban/exportdir_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/exportzip_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/workset_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_DLGBAN_SAVEAS_DLG", "$nl$/icons/full/wizban/saveas_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_DLGBAN_QUICKFIX_DLG", "$nl$/icons/full/wizban/quick_fix.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT", "$nl$/icons/full/obj16/prj_obj.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT_CLOSED", "$nl$/icons/full/obj16/cprj_obj.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OPEN_MARKER", "$nl$/icons/full/elcl16/gotoobj_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ELCL_QUICK_FIX_ENABLED", "$nl$/icons/full/elcl16/smartmode_co.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_DLCL_QUICK_FIX_DISABLED", "$nl$/icons/full/dlcl16/smartmode_co.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_FIXABLE_WARNING", "$nl$/icons/full/obj16/quickfix_warning_obj.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_FIXABLE_ERROR", "$nl$/icons/full/obj16/quickfix_error_obj.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_FIXABLE_INFO", "$nl$/icons/full/obj16/quickfix_info_obj.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_TASK_TSK", "$nl$/icons/full/obj16/taskmrk_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_BKMRK_TSK", "$nl$/icons/full/obj16/bkmrk_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_COMPLETE_TSK", "$nl$/icons/full/obj16/complete_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INCOMPLETE_TSK", "$nl$/icons/full/obj16/incomplete_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_ITEM", "$nl$/icons/full/obj16/welcome_item.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_BANNER", "$nl$/icons/full/obj16/welcome_banner.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_ERROR_PATH", "$nl$/icons/full/obj16/error_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WARNING_PATH", "$nl$/icons/full/obj16/warn_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INFO_PATH", "$nl$/icons/full/obj16/info_tsk.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_LCL_FLAT_LAYOUT", "$nl$/icons/full/elcl16/flatLayout.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_LCL_HIERARCHICAL_LAYOUT", "$nl$/icons/full/elcl16/hierarchicalLayout.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEM_CATEGORY", "$nl$/icons/full/etool16/problem_category.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEMS_VIEW", "$nl$/icons/full/eview16/problems_view.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEMS_VIEW_ERROR", "$nl$/icons/full/eview16/problems_view_error.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEMS_VIEW_WARNING", "$nl$/icons/full/eview16/problems_view_warning.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEMS_VIEW_INFO", "$nl$/icons/full/eview16/problems_view_info.png", true);
    }

    private void declareWorkbenchImage(Bundle ideBundle, String symbolicName, String path, boolean shared) {
        URL url = FileLocator.find((Bundle)ideBundle, (IPath)new Path(path), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.getWorkbenchConfigurer().declareImage(symbolicName, desc, shared);
    }

    public IAdaptable getDefaultPageInput() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot();
    }

    public String getInitialWindowPerspectiveId() {
        return "com.jaspersoft.studio.ReportDesignPerspective";
    }

    public void preStartup() {
        super.preStartup();
        IDE.registerAdapters();
        this.setRepositories();
    }

    public void postStartup() {
        super.postStartup();
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        pm.remove("org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Startup/org.eclipse.ui.preferencePages.Startup.Workspaces");
    }

    protected void setRepositories() {
        try {
            URL siteEntry = FileLocator.toFileURL((URL)BundleCommonUtils.getBundle((String)"com.jaspersoft.studio.rcp").getEntry("updatesite.properties"));
            InputStream propsIS = siteEntry.openStream();
            Properties props = new Properties();
            props.load(propsIS);
            String[] updateSiteItems = new String[]{"jaspersoftstudio.ce.updatesite", "eclipse.project.updatesite.1", "eclipse.project.updatesite.2"};
            ArrayList<String> updateSiteURLs = new ArrayList<String>();
            String[] stringArray = updateSiteItems;
            int n = updateSiteItems.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                String urlString = props.getProperty(str);
                if (urlString != null && !urlString.trim().isEmpty()) {
                    updateSiteURLs.add(urlString);
                }
                ++n2;
            }
            if (!updateSiteURLs.isEmpty()) {
                P2Util.setRepositories(updateSiteURLs);
            }
        }
        catch (Exception e) {
            BundleCommonUtils.logError((String)"com.jaspersoft.studio.rcp", (String)Messages.ApplicationWorkbenchAdvisor_RepositoryURLReadError, (Throwable)e);
        }
    }

    public void eventLoopIdle(Display display) {
        this.openDocProcessor.openFiles();
        super.eventLoopIdle(display);
    }
}

