/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.rcp.intro;

import com.jaspersoft.studio.rcp.intro.ApplicationActionBarAdvisor;
import com.jaspersoft.studio.rcp.messages.Messages;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(new Point(1024, 768));
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowFastViewBars(true);
        configurer.setShowMenuBar(true);
        configurer.setShowProgressIndicator(true);
        configurer.setShowPerspectiveBar(true);
        IProduct product = Platform.getProduct();
        if (product != null && product.getName() != null) {
            configurer.setTitle(product.getName());
        } else {
            configurer.setTitle(Messages.ApplicationWorkbenchWindowAdvisor_jasper_open_studio);
        }
        IPartService service = (IPartService)configurer.getWindow().getService(IPartService.class);
        service.addPartListener(new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
                try {
                    String name = part.getSite().getId();
                    if ("org.eclipse.ui.internal.introview".equals(name) && part != null && part instanceof IViewPart) {
                        final IViewPart thePart = (IViewPart)part;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchPage activePage;
                                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
                                    activePage.hideView(thePart);
                                }
                            }
                        });
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public void partOpened(IWorkbenchPart part) {
            }
        });
    }

    public void postWindowOpen() {
        this.getWindowConfigurer().getWindow().getShell().setMaximized(true);
    }
}

