/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.data;

import de.effectivecompany.base.data.BusinessDataObject;
import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.base.efcbl.util.BaseDomainObject;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBusinessData
extends BaseDomainObject
implements BusinessDataObject,
LazyLoader {
    private static final long serialVersionUID = 9011029655960615219L;
    private static Logger logger = LoggerFactory.getLogger(AbstractBusinessData.class);
    private Lock locked = new ReentrantLock(true);

    @Override
    public String getGroupName(int groupid) {
        return this.getGroupKey(groupid).toString();
    }

    @Override
    public int getGroupId(String groupkey) {
        for (int i = 0; i < this.getGroupCount(); ++i) {
            if (!this.getGroupKey(i).equals(groupkey)) continue;
            return i;
        }
        logger.debug("group key not found: " + groupkey);
        return 0;
    }

    @Override
    public int getDatasetId(String listkey) {
        for (int i = 0; i < this.getDatasetCount(); ++i) {
            if (!this.getDatasetKey(i).equals(listkey)) continue;
            return i;
        }
        logger.debug("dataset key not found: " + listkey);
        return 0;
    }

    @Override
    public abstract BusinessObject getValue(int var1, int var2);

    @Override
    public BusinessObject getValue(int datalist, String group) {
        return this.getValue(datalist, this.getGroupId(group));
    }

    @Override
    public BusinessObject getValue(String datasetKey, String groupKey) {
        return this.getValue(this.getDatasetId(datasetKey), groupKey);
    }

    @Override
    public abstract void setValue(int var1, int var2, BusinessObject var3);

    @Override
    public void setValue(String datasetKey, String groupKey, BusinessObject data) {
        this.setValue(this.getDatasetId(datasetKey), this.getGroupId(groupKey), data);
    }

    @Override
    public void lock() {
        this.locked.lock();
    }

    @Override
    public void unlock() {
        this.locked.unlock();
    }
}

