/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.data;

import de.effectivecompany.base.data.AbstractStatisticData;
import de.effectivecompany.base.data.StatisticListEntry;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractStatisticListData
extends AbstractStatisticData
implements Serializable {
    private static final long serialVersionUID = -1164401906446951994L;
    private List<String> groups;
    private Map<String, String> groupnames;
    private List<String> dataset;
    private Map<String, String> datasetnames;
    private static int NUMBERFIELD_SIZE = 5;
    private List<List<Number[]>> data = new LinkedList<List<Number[]>>();

    public AbstractStatisticListData() {
        this.groups = new LinkedList<String>();
        this.dataset = new LinkedList<String>();
        this.groupnames = new LinkedHashMap<String, String>();
        this.datasetnames = new LinkedHashMap<String, String>();
    }

    public void loadData(List<StatisticListEntry> statdata) {
        for (StatisticListEntry entry : statdata) {
            if (this.groups.contains(entry.getGroup())) continue;
            this.groups.add(entry.getGroup());
        }
        for (StatisticListEntry entry : statdata) {
            if (this.dataset.contains(entry.getDataset())) continue;
            this.dataset.add(entry.getDataset());
            this.data.add(new LinkedList());
            int id = this.dataset.indexOf(entry.getDataset());
            for (int i = 0; i < this.groups.size(); ++i) {
                this.data.get(id).add(new Number[NUMBERFIELD_SIZE]);
            }
        }
        for (StatisticListEntry entry : statdata) {
            int setid = this.dataset.indexOf(entry.getDataset());
            int groupid = this.groups.indexOf(entry.getGroup());
            this.data.get(setid).set(groupid, entry.getValues());
        }
    }

    public void loadData(EFCList<StatisticListEntry> statdata, EFCMap<EFCString, EFCString> allgroups, EFCMap<EFCString, EFCString> alldatasets) {
        for (Map.Entry e : allgroups.entrySet()) {
            if (this.groups.contains(((EFCString)e.getKey()).getData())) continue;
            this.groups.add(((EFCString)e.getKey()).toString());
            this.groupnames.put(((EFCString)e.getKey()).toString(), ((EFCString)e.getValue()).toString());
        }
        for (Map.Entry e : alldatasets.entrySet()) {
            String comp = ((EFCString)e.getKey()).toString();
            if (this.dataset.contains(comp)) continue;
            this.dataset.add(comp);
            this.datasetnames.put(comp, ((EFCString)e.getValue()).toString());
            this.data.add(new LinkedList());
            int id = this.dataset.indexOf(comp);
            for (int i = 0; i < this.groups.size(); ++i) {
                this.data.get(id).add(new Number[5]);
            }
        }
        for (StatisticListEntry entry : statdata) {
            int setid = this.dataset.indexOf(entry.getDataset());
            int groupid = this.groups.indexOf(entry.getGroup());
            if (groupid < 0 || setid < 0) {
                System.err.println("invalid group or dataset selected: g=" + entry.getGroup() + " | d=" + entry.getDataset());
                continue;
            }
            this.data.get(setid).set(groupid, entry.getValues());
        }
    }

    public void loadData(List<StatisticListEntry> statdata, Map<String, String> allgroups, Map<String, String> alldatasets) {
        for (Map.Entry<String, String> e : allgroups.entrySet()) {
            if (this.groups.contains(e.getKey())) continue;
            this.groups.add(e.getKey());
            this.groupnames.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, String> e : alldatasets.entrySet()) {
            String comp = e.getKey();
            if (this.dataset.contains(comp)) continue;
            this.dataset.add(comp);
            this.datasetnames.put(comp, e.getValue());
            this.data.add(new LinkedList());
            int id = this.dataset.indexOf(comp);
            for (int i = 0; i < this.groups.size(); ++i) {
                this.data.get(id).add(new Number[5]);
            }
        }
        for (StatisticListEntry entry : statdata) {
            int setid = this.dataset.indexOf(entry.getDataset());
            int groupid = this.groups.indexOf(entry.getGroup());
            if (groupid < 0 || setid < 0) {
                System.err.println("invalid group or dataset selected: g=" + entry.getGroup() + " | d=" + entry.getDataset());
                continue;
            }
            this.data.get(setid).set(groupid, entry.getValues());
        }
    }

    @Override
    public int getGroupCount() {
        return this.groups.size();
    }

    @Override
    public String getGroupKey(int groupid) {
        return this.groups.get(groupid);
    }

    @Override
    public int getDatasetCount() {
        return this.data.size();
    }

    @Override
    public String getDatasetName(int datalist) {
        if (this.datasetnames.keySet().contains(this.getDatasetKey(datalist))) {
            return this.datasetnames.get(this.getDatasetKey(datalist));
        }
        return this.dataset.get(datalist).toString();
    }

    @Override
    public String getDatasetKey(int datasetid) {
        return this.dataset.get(datasetid);
    }

    @Override
    public String getGroupName(int groupid) {
        if (this.groupnames.keySet().contains(this.getGroupKey(groupid))) {
            return this.groupnames.get(this.getGroupKey(groupid));
        }
        return this.groups.get(groupid).toString();
    }

    @Override
    public String[] getDatasetKeys() {
        return this.dataset.toArray(new String[0]);
    }

    @Override
    public String[] getGroupKeys() {
        return this.groups.toArray(new String[0]);
    }

    @Override
    public Number[] getValues(int datalist, int group) {
        return this.data.get(datalist).get(group);
    }
}

