/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.BaseType;
import de.effectivecompany.base.datatypes.EFCFloat;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCLong;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.Metadata;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.datatypes.json.EFCAlphaNumericJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCAlphaNumericJsonSerializer;
import java.security.InvalidParameterException;
import java.util.Objects;

@JsonIgnoreProperties(value={"maxsize", "minsize", "metadata", "init"})
@JsonSerialize(using=EFCAlphaNumericJsonSerializer.class)
@JsonDeserialize(using=EFCAlphaNumericJsonDeserializer.class)
public class EFCAlphaNumeric
extends BaseType
implements Comparable<EFCAlphaNumeric> {
    private static final long serialVersionUID = -2201962835274204933L;
    protected String data = null;

    public EFCAlphaNumeric() {
        this((String)null);
    }

    public EFCAlphaNumeric(EFCAlphaNumeric val) {
        if (val != null) {
            this.data = val.data != null ? new String(val.data) : null;
            this.putMetadata(val.getMetadata());
        } else {
            this.data = null;
            this.setUnInitialized();
        }
    }

    public EFCAlphaNumeric(String val) {
        if (val != null) {
            this.putValue(val);
            this.putMetadata(null);
        } else {
            this.data = null;
            this.setUnInitialized();
        }
    }

    @Override
    protected void nullData() {
        this.data = null;
        this.setUnInitialized();
    }

    @Override
    public Object optainValue() {
        return this.data;
    }

    @Override
    public void putValue(Object o) {
        if (this == o) {
            return;
        }
        if (o == null) {
            this.nullData();
            return;
        }
        this.setInitialized();
        if (o instanceof Type) {
            this.putValue(((Type)o).optainValue());
        } else if (o instanceof String) {
            this.data = (String)o;
        } else if (o instanceof Integer) {
            this.data = ((Integer)o).toString();
        } else if (o instanceof Double) {
            this.data = ((Double)o).toString();
        } else if (o instanceof Long) {
            this.data = ((Long)o).toString();
        } else {
            throw new InvalidParameterException("Could not convert value to string, class " + o.getClass().getName());
        }
    }

    public String getData() {
        return this.data;
    }

    public void setData(String s) {
        if (s != null && this.data != null && this.data.equals(s)) {
            return;
        }
        this.data = s;
        if (this.data != null) {
            this.setInitialized();
        } else {
            this.setUnInitialized();
        }
    }

    public String toString() {
        if (this.data == null) {
            return "";
        }
        return this.data;
    }

    public EFCAlphaNumeric toEFCAlphaNumeric() {
        if (this.data == null) {
            return new EFCAlphaNumeric("");
        }
        return new EFCAlphaNumeric(this.data);
    }

    public EFCString toEFCString() {
        if (this.data == null) {
            return new EFCString("");
        }
        return new EFCString(this.data);
    }

    public EFCAlphaNumeric plus(EFCAlphaNumeric str) {
        EFCAlphaNumeric ret = new EFCAlphaNumeric(this.data + str.optainValue());
        return ret;
    }

    public EFCAlphaNumeric plus(String str) {
        EFCAlphaNumeric ret = new EFCAlphaNumeric(this.data + str);
        return ret;
    }

    public EFCAlphaNumeric plus(EFCString str) {
        EFCAlphaNumeric ret = new EFCAlphaNumeric(this.data + str.optainValue());
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EFCAlphaNumeric) {
            return this.equals((EFCAlphaNumeric)obj);
        }
        if (obj instanceof EFCString) {
            return this.equals((EFCString)obj);
        }
        if (obj instanceof String) {
            String val = (String)obj;
            if (this.data == null || val == null) {
                return false;
            }
            return this.data.equals(val);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.data, this.isInitialized(), this.isModified());
    }

    public boolean equals(EFCAlphaNumeric str) {
        if (str == null) {
            return false;
        }
        String val = str.getData();
        if (val == null && this.data == null) {
            return true;
        }
        if (this.data == null || val == null) {
            return false;
        }
        return this.data.equals(val);
    }

    @Override
    public int compareTo(EFCAlphaNumeric str) {
        if (this.data == null) {
            if (str == null || str.getData() == null) {
                return 0;
            }
            return -1;
        }
        if (str == null || str.getData() == null) {
            return 1;
        }
        return this.data.compareToIgnoreCase(str.getData());
    }

    public boolean equals(EFCString str) {
        if (str == null) {
            return false;
        }
        String val = str.getData();
        if (val == null && this.data == null) {
            return true;
        }
        if (this.data == null || val == null) {
            return false;
        }
        return this.data.equals(val);
    }

    @Override
    public int compareTo(EFCString str) {
        if (this.data == null) {
            if (str == null || str.getData() == null) {
                return 0;
            }
            return -1;
        }
        if (str == null || str.getData() == null) {
            return 1;
        }
        return this.data.compareToIgnoreCase(str.getData());
    }

    @Override
    public int compareTo(EFCInteger v) {
        return v.compareTo(this) * -1;
    }

    @Override
    public int compareTo(EFCLong v) {
        return v.compareTo(this) * -1;
    }

    @Override
    public int compareTo(EFCFloat v) {
        return v.compareTo(this) * -1;
    }

    @Override
    public int compareTo(byte v) {
        return Byte.valueOf(this.getData()).compareTo(v);
    }

    @Override
    public int compareTo(int v) {
        return Integer.valueOf(this.getData()).compareTo(v);
    }

    @Override
    public int compareTo(long v) {
        return Long.valueOf(this.getData()).compareTo(v);
    }

    @Override
    public int compareTo(float v) {
        return Float.valueOf(this.getData()).compareTo(Float.valueOf(v));
    }

    @Override
    public int compareTo(double v) {
        return Double.valueOf(this.getData()).compareTo(v);
    }

    @Override
    public int compareTo(String str) {
        return this.data.compareToIgnoreCase(str);
    }

    public boolean contains(EFCAlphaNumeric v) {
        return this.contains(v.data);
    }

    public boolean contains(EFCString v) {
        return this.contains(v.getData());
    }

    public boolean contains(CharSequence v) {
        if (this.data == null) {
            return false;
        }
        return this.data.contains(v);
    }

    public int indexOf(EFCAlphaNumeric v) {
        if (v != null) {
            return this.indexOf(v.data);
        }
        return -1;
    }

    public int indexOf(EFCString v) {
        if (v != null) {
            return this.indexOf(v.getData());
        }
        return -1;
    }

    public int indexOf(String v) {
        if (this.data != null && v != null) {
            return this.data.indexOf(v);
        }
        return -1;
    }

    public int lastIndexOf(EFCAlphaNumeric v) {
        return this.lastIndexOf(v.data);
    }

    public int lastIndexOf(String v) {
        if (this.data != null && v != null) {
            return this.data.lastIndexOf(v);
        }
        return -1;
    }

    public EFCString subEFCString(int start) {
        EFCString result = new EFCString(this.data);
        result.putValue(this.data.substring(start));
        return result;
    }

    public EFCString subEFCString(int start, int end) {
        EFCString result = new EFCString(this.data);
        result.putValue(this.data.substring(start, end));
        return result;
    }

    public EFCAlphaNumeric subEFCAlphaNumeric(int start) {
        EFCAlphaNumeric result = new EFCAlphaNumeric(this);
        result.data = this.data.substring(start);
        return result;
    }

    public EFCAlphaNumeric subEFCAlphaNumeric(int start, int end) {
        EFCAlphaNumeric result = new EFCAlphaNumeric(this);
        result.data = this.data.substring(start, end);
        return result;
    }

    public String subString(int start) {
        return this.data.substring(start);
    }

    public String subString(int start, int end) {
        return this.data.substring(start, end);
    }

    public int subStrCount(EFCAlphaNumeric v) {
        return this.subStrCount(v.data);
    }

    public int subStrCount(EFCString v) {
        return this.subStrCount(v.getData());
    }

    public int subStrCount(String v) {
        int i = -1;
        int count = 0;
        while ((i = this.data.indexOf(v, i + 1)) >= 0) {
            ++count;
        }
        return count;
    }

    public EFCAlphaNumeric clone() {
        return new EFCAlphaNumeric(this);
    }

    @Override
    public void defaults() {
        this.setData("");
    }

    public void putMetadata(Metadata meta) {
        if (meta != null) {
            this.putInit(meta.isInit());
            this.putModified(meta.isModified());
        } else {
            this.putInit(true);
            this.putModified(true);
        }
    }

    @Override
    public long getMaxsize() {
        return -1L;
    }

    @Override
    public void putMaxsize(long maxsize) {
        throw new RuntimeException("putMaxsize call not allowed");
    }

    @Override
    public void putMinsize(long minsize) {
        throw new RuntimeException("putMinsize call not allowed");
    }

    @Override
    public long getMinsize() {
        return -1L;
    }
}

