/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.BaseType;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.json.EFCBlobJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCBlobJsonSerializer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.apache.tika.Tika;

@JsonIgnoreProperties(value={"maxsize", "minsize", "metadata", "init", "inputstream"})
@JsonSerialize(using=EFCBlobJsonSerializer.class)
@JsonDeserialize(using=EFCBlobJsonDeserializer.class)
public final class EFCBlob
extends BaseType {
    private static final long serialVersionUID = 1745697079361780146L;
    private byte[] data = null;
    private String mediaType = "application";
    private String subType = "octet-stream";

    public EFCBlob() {
        this.resetMIMEType();
    }

    public EFCBlob(String s) {
        if (s != null) {
            this.data = s.getBytes(StandardCharsets.UTF_8);
            this.determineMIMEType();
        } else {
            this.data = null;
        }
    }

    public EFCBlob(EFCString s) {
        if (s != null) {
            this.data = s.getData().getBytes(StandardCharsets.UTF_8);
            this.determineMIMEType();
        } else {
            this.data = null;
        }
    }

    public EFCBlob(byte[] newData) {
        this.data = newData;
        this.determineMIMEType();
        this.setInitialized();
    }

    public EFCBlob(EFCBlob newData) {
        this();
        if (newData != null && newData.getData() != null) {
            this.data = Arrays.copyOf(newData.getData(), newData.getData().length);
            this.mediaType = newData.getMediaType() != null ? new String(newData.getMediaType()) : null;
            this.subType = newData.getSubType() != null ? new String(newData.getSubType()) : null;
            this.setInitialized();
        }
    }

    @Override
    protected void nullData() {
        this.data = null;
        this.setUnInitialized();
        this.resetMIMEType();
    }

    public int length() {
        int ret = -1;
        if (this.data != null) {
            ret = this.data.length;
        }
        return ret;
    }

    public ByteArrayInputStream getInputStream() {
        return new ByteArrayInputStream(this.data != null ? this.data : new byte[]{});
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        if (data != null) {
            this.data = data;
            this.determineMIMEType();
            this.setInitialized();
        } else {
            this.nullData();
        }
    }

    @Override
    public Object optainValue() {
        return this.data;
    }

    @Override
    public void putValue(Object o) {
        if (this == o) {
            return;
        }
        if (o == null) {
            this.nullData();
        } else if (o instanceof byte[]) {
            this.data = (byte[])o;
            this.determineMIMEType();
        } else if (o instanceof String) {
            this.data = ((String)o).getBytes(StandardCharsets.UTF_8);
            this.determineMIMEType();
        } else if (o instanceof EFCString) {
            this.data = ((EFCString)o).getData().getBytes(StandardCharsets.UTF_8);
            this.determineMIMEType();
        } else if (o instanceof EFCBlob) {
            this.data = ((EFCBlob)o).getData();
            this.determineMIMEType();
        } else {
            throw new RuntimeException("Only byte arrays, String, EFCString or EFCBlobs are supported!");
        }
        this.setInitialized();
    }

    private void determineMIMEType() {
        if (this.data != null) {
            Tika tika = new Tika();
            this.setMediaType(tika.detect(this.data));
        } else {
            this.resetMIMEType();
        }
    }

    private void resetMIMEType() {
        this.mediaType = "application";
        this.subType = "octet-stream";
    }

    public void exportToFile(File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            if (this.data != null) {
                fos.write(this.data);
            }
        }
    }

    public void importFromFile(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            int offset;
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                throw new RuntimeException("File is too large to process");
            }
            this.data = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < this.data.length && (numRead = ((InputStream)is).read(this.data, offset, this.data.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < this.data.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        this.determineMIMEType();
    }

    public boolean equals(Object obj) {
        return obj instanceof EFCBlob && Arrays.equals(((EFCBlob)obj).data, this.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.data, this.isInitialized(), this.isModified(), this.mediaType, this.subType);
    }

    public EFCBlob clone() {
        return new EFCBlob(this);
    }

    public void setMediaType(String mediaType) {
        if (mediaType != null) {
            this.mediaType = mediaType;
        }
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getMIMEType() {
        return this.mediaType + "/" + this.subType;
    }

    public void setSubType(String subType) {
        if (subType != null) {
            this.subType = subType;
        }
    }

    public String getSubType() {
        return this.subType;
    }

    @Override
    public void defaults() {
        this.setData(new byte[]{0});
    }

    public String toString() {
        if (this.data != null) {
            return new String(this.data, StandardCharsets.UTF_8);
        }
        return "";
    }

    @Override
    public long getMaxsize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getMinsize() {
        return 0L;
    }

    @Override
    public void putMaxsize(long maxsize) {
        throw new RuntimeException("putMaxsize call not allowed");
    }

    @Override
    public void putMinsize(long minsize) {
        throw new RuntimeException("putMinsize call not allowed");
    }
}

