/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.BaseType;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCLong;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.Metadata;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.datatypes.json.EFCBooleanJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCBooleanJsonSerializer;
import java.security.InvalidParameterException;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(value={"boolean", "init", "maxsize", "minsize", "metadata"})
@JsonSerialize(using=EFCBooleanJsonSerializer.class)
@JsonDeserialize(using=EFCBooleanJsonDeserializer.class)
public final class EFCBoolean
extends BaseType
implements Comparable<EFCBoolean> {
    private static final long serialVersionUID = -891555599424529621L;
    protected Boolean data;

    public EFCBoolean() {
    }

    public EFCBoolean(Boolean b) {
        this.data = b;
        if (this.data != null) {
            this.setInitialized();
        } else {
            this.setUnInitialized();
        }
    }

    public EFCBoolean(Optional<?> val) {
        if (val != null) {
            this.data = val.isPresent();
            this.setInitialized();
        } else {
            this.setUnInitialized();
        }
    }

    public EFCBoolean(Integer val) {
        if (val != null) {
            this.data = val == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.setInitialized();
        } else {
            this.setUnInitialized();
        }
    }

    public EFCBoolean(EFCInteger val) {
        if (val != null) {
            this.data = val.getIntValue() == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.setInitialized();
        } else {
            this.setUnInitialized();
        }
    }

    public EFCBoolean(Long val) {
        if (val != null) {
            this.data = val == 1L ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.setInitialized();
        } else {
            this.setUnInitialized();
        }
    }

    public EFCBoolean(EFCLong val) {
        if (val != null) {
            this.data = val.getIntValue() == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.setInitialized();
        } else {
            this.setUnInitialized();
        }
    }

    public EFCBoolean(String val) {
        if (val != null) {
            if (val.equalsIgnoreCase("false")) {
                this.data = false;
            } else if (val.equalsIgnoreCase("true")) {
                this.data = true;
            } else {
                try {
                    long i = Long.parseLong(val.trim());
                    this.data = i == 1L ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
                catch (NumberFormatException nfe) {
                    this.nullData();
                    return;
                }
            }
        }
        this.setInitialized();
    }

    public EFCBoolean(EFCString val) {
        if (val != null) {
            if (val.getData().equalsIgnoreCase("false")) {
                this.data = false;
            } else if (val.getData().equalsIgnoreCase("true")) {
                this.data = true;
            } else {
                try {
                    int i = Integer.parseInt(val.getData().trim());
                    this.data = i == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
                catch (NumberFormatException nfe) {
                    this.nullData();
                    return;
                }
            }
        }
        this.setInitialized();
    }

    public EFCBoolean(EFCBoolean val) {
        this();
        if (val != null) {
            this.data = val.data;
            this.putMetadata(val.getMetadata());
        }
    }

    public void putMetadata(Metadata meta) {
        this.putInit(meta.isInit());
        this.putModified(meta.isModified());
    }

    @Override
    public Object optainValue() {
        return this.data;
    }

    public int getInt() {
        if (this.data == null) {
            return -1;
        }
        if (this.data.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public Boolean getBoolean() {
        return this.data;
    }

    @Override
    protected void nullData() {
        this.data = null;
        this.setUnInitialized();
    }

    @Override
    public void putValue(Object o) {
        Object value;
        if (this == o) {
            return;
        }
        if (o instanceof Type && (value = ((Type)o).optainValue()) == null) {
            this.nullData();
            return;
        }
        if (o == null) {
            this.nullData();
            return;
        }
        if (o instanceof Boolean) {
            this.data = (Boolean)o;
        } else if (o instanceof Integer) {
            this.data = (Integer)o != 0;
        } else if (o instanceof EFCBoolean) {
            this.data = ((EFCBoolean)o).getInt() != 0;
        } else if (o instanceof String) {
            this.data = !((String)o).isEmpty() ? Boolean.valueOf(!"0".equals(o)) : Boolean.valueOf(false);
        } else {
            throw new InvalidParameterException("Boolean, integer or string object expected");
        }
        this.setInitialized();
    }

    public String toString() {
        if (this.data == null) {
            return "";
        }
        if (this.data.booleanValue()) {
            return "true";
        }
        return "false";
    }

    public Integer toInteger() {
        if (this.data == null) {
            return null;
        }
        if (this.data.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public void setData(Boolean newData) {
        if (newData != null && this.data != null && this.data.equals(newData)) {
            return;
        }
        this.putValue(newData);
    }

    public Boolean getData() {
        return this.data;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.data, this.isInitialized(), this.isModified());
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof EFCBoolean) {
            if (this.data != null) {
                return this.data.equals(((EFCBoolean)otherObject).data);
            }
            return ((EFCBoolean)otherObject).data == null;
        }
        if (otherObject instanceof Boolean) {
            if (this.data != null) {
                return this.data.equals((Boolean)otherObject);
            }
            return false;
        }
        return false;
    }

    @Override
    public int compareTo(EFCBoolean i) {
        if (this.data == null && i.getData() == null) {
            return 0;
        }
        if (this.data != null && i != null && i.getData() != null) {
            return this.data.compareTo(i.getData());
        }
        return -1;
    }

    public boolean compareTo(boolean i) {
        return this.data == i;
    }

    public EFCBoolean clone() {
        return new EFCBoolean(this);
    }

    @Override
    public void defaults() {
        this.setData(false);
    }

    @Override
    public long getMaxsize() {
        return 1L;
    }

    @Override
    public long getMinsize() {
        return 1L;
    }

    @Override
    public void putMaxsize(long maxsize) {
        throw new RuntimeException("putMaxsize call not allowed");
    }

    @Override
    public void putMinsize(long minsize) {
        throw new RuntimeException("putMinsize call not allowed");
    }
}

