/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.BaseType;
import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.Metadata;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.datatypes.json.EFCDateTimeJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCDateTimeJsonSerializer;
import java.security.InvalidParameterException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;

@JsonIgnoreProperties(value={"date", "datetimeinmillis", "maxsize", "minsize", "metadata"})
@JsonSerialize(using=EFCDateTimeJsonSerializer.class)
@JsonDeserialize(using=EFCDateTimeJsonDeserializer.class)
public class EFCDateTime
extends BaseType
implements Comparable<EFCDateTime> {
    private static final long serialVersionUID = -2833091715636414355L;
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATETIME_PATTERN_ALT_1 = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String TIME_PATTERN = "HH:mm:ss";
    public static final String TIME_PATTERN_ALT_1 = "HH:mm:ss.SSS";
    public static final String TIME_PATTERN_ALT_2 = "HH:mm";
    public static final String TIME_PATTERN_ALT_3 = "HHmm";
    public static final String TIME_PATTERN_ALT_4 = "EEE MMM dd HH:mm:ss.SSS zzz yyyy";
    public static final String TIME_PATTERN_ALT_5 = "EEE MMM dd HH:mm:ss zzz yyyy";
    public static final ZoneId DEFAULT_TIME_ZONE = ZoneId.of("Europe/Berlin");
    protected Long data = null;
    protected static DateFormat formatDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected static DateFormat formatDateTimeAlt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected static DateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
    protected static DateFormat formatTime = new SimpleDateFormat("HH:mm:ss");
    protected static DateFormat formatTimeAlt1 = new SimpleDateFormat("HH:mm:ss.SSS");
    protected static DateFormat formatTimeAlt2 = new SimpleDateFormat("HH:mm");
    protected static DateFormat formatTimeAlt3 = new SimpleDateFormat("HHmm", Locale.ENGLISH);
    protected static DateFormat formatTimeAlt4 = new SimpleDateFormat("EEE MMM dd HH:mm:ss.SSS zzz yyyy", Locale.ENGLISH);
    protected static DateFormat formatTimeAlt5 = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);

    public EFCDateTime() {
        this.setData(null);
    }

    public EFCDateTime(Long date) {
        this();
        this.putValue(date);
    }

    public EFCDateTime(Date date) {
        this();
        this.putValue(date);
    }

    public EFCDateTime(LocalDateTime date) {
        this();
        this.putValue(date);
    }

    public EFCDateTime(String date) {
        this();
        this.putValue(date);
    }

    public EFCDateTime(EFCDate date) {
        this();
        this.putValue(date);
    }

    public EFCDateTime(EFCString date) {
        this();
        this.putValue(date);
    }

    public EFCDateTime(EFCDateTime val) {
        this();
        if (val != null) {
            this.data = val.data;
            this.putMetadata(val.getMetadata());
        }
    }

    @Override
    protected void nullData() {
        this.data = null;
        this.setUnInitialized();
    }

    @Override
    public Long optainValue() {
        return this.data;
    }

    public Date getDate() {
        if (this.data == null) {
            return null;
        }
        return new Date(this.data);
    }

    public Date toDate() {
        return this.getDate();
    }

    public long getDateTimeInMillis() {
        if (this.data == null) {
            return 0L;
        }
        return this.data;
    }

    @Override
    public void putValue(Object o) {
        Object value;
        if (this == o) {
            return;
        }
        if (o instanceof Type && (value = ((Type)o).optainValue()) == null) {
            if (this.getData() != null) {
                this.setData(null);
            }
            return;
        }
        if (o == null) {
            if (this.getData() != null) {
                this.setData(null);
            }
            return;
        }
        if (o instanceof Date) {
            this.setData(((Date)o).getTime());
        } else if (o instanceof Long) {
            this.setData((Long)o);
        } else if (o instanceof Integer) {
            this.setData(((Integer)o).longValue());
        } else if (o instanceof LocalDateTime) {
            this.setData(((LocalDateTime)o).atZone(DEFAULT_TIME_ZONE).toInstant().toEpochMilli());
        } else if (o instanceof EFCString) {
            this.putValue(((EFCString)o).getData());
        } else if (o instanceof String) {
            if (((String)o).trim().equals("")) {
                if (this.getData() != null) {
                    this.setData(null);
                }
                return;
            }
            try {
                this.setData(formatDateTime.parse((String)o).getTime());
            }
            catch (ParseException e) {
                try {
                    this.setData(formatDateTimeAlt.parse((String)o).getTime());
                }
                catch (ParseException e2) {
                    try {
                        this.setData(formatDate.parse((String)o).getTime());
                    }
                    catch (ParseException e3) {
                        try {
                            this.setData(formatTime.parse((String)o).getTime());
                        }
                        catch (ParseException e4) {
                            try {
                                this.setData(formatTimeAlt1.parse((String)o).getTime());
                            }
                            catch (ParseException e5) {
                                try {
                                    this.setData(formatTimeAlt2.parse((String)o).getTime());
                                }
                                catch (ParseException e6) {
                                    try {
                                        this.setData(formatTimeAlt3.parse((String)o).getTime());
                                    }
                                    catch (ParseException e7) {
                                        try {
                                            this.setData(formatTimeAlt4.parse((String)o).getTime());
                                        }
                                        catch (ParseException e8) {
                                            try {
                                                this.setData(formatTimeAlt5.parse((String)o).getTime());
                                            }
                                            catch (ParseException e9) {
                                                throw new IllegalArgumentException("wrong date/time format: " + e9.getMessage(), e9);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (o instanceof EFCDate) {
            this.setData(((EFCDate)o).getDateTimeInMillis());
        } else if (o instanceof EFCDateTime) {
            this.setData(((EFCDateTime)o).getDateTimeInMillis());
        } else {
            throw new InvalidParameterException("Date, integer or string object expected");
        }
        this.setInitialized();
    }

    private long setMillisToZero(Long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(date));
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public String toString() {
        if (this.data == null) {
            return "";
        }
        return formatDateTime.format(this.getDate());
    }

    public void setData(Long newData) {
        if (newData != null && this.data != null && this.data.equals(newData)) {
            return;
        }
        this.data = newData;
        if (this.data != null) {
            this.setInitialized();
            this.data = this.setMillisToZero(this.data);
        } else {
            this.setUnInitialized();
        }
    }

    public Long getData() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EFCDateTime) {
            return this.equals((EFCDateTime)obj);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.data, this.isInitialized(), this.isModified());
    }

    public boolean equals(EFCDateTime i) {
        if (i == null) {
            return false;
        }
        if (this.data == null && i.data == null) {
            return true;
        }
        if (this.data == null || i.data == null) {
            return false;
        }
        return this.data.equals(i.data);
    }

    public boolean equals(long i) {
        return this.data == i;
    }

    @Override
    public int compareTo(EFCDateTime i) {
        if (i == null) {
            return -1;
        }
        if (this.data == null) {
            if (i.data == null) {
                return 0;
            }
            return -1;
        }
        if (i.data == null) {
            return 1;
        }
        return this.data.compareTo(i.data);
    }

    @Override
    public int compareTo(long i) {
        return this.data.compareTo(i);
    }

    @Override
    public int compareTo(EFCDate i) {
        return this.data.compareTo(i.getData());
    }

    public EFCDateTime clone() {
        return new EFCDateTime(this);
    }

    @Override
    public void defaults() {
        formatDateTime = new SimpleDateFormat(DATETIME_PATTERN);
        formatDate = new SimpleDateFormat(DATE_PATTERN);
        formatTime = new SimpleDateFormat(TIME_PATTERN);
        this.setData(System.currentTimeMillis());
    }

    public void defaultsLocale() {
        formatDate = DateFormat.getDateInstance();
        formatTime = DateFormat.getTimeInstance();
        formatDateTime = DateFormat.getDateTimeInstance();
        this.setData(System.currentTimeMillis());
    }

    @Override
    public long getMaxsize() {
        return -1L;
    }

    @Override
    public long getMinsize() {
        return 0L;
    }

    @Override
    public void putMaxsize(long maxsize) {
        throw new RuntimeException("putMaxsize call not allowed");
    }

    @Override
    public void putMinsize(long minsize) {
        throw new RuntimeException("putMinsize call not allowed");
    }

    public void putMetadata(Metadata meta) {
        this.putInit(meta.isInit());
        this.putModified(meta.isModified());
    }
}

