/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCLong;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.NumberType;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.datatypes.json.EFCFloatJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCFloatJsonSerializer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Objects;

@JsonIgnoreProperties(value={"doublevalue", "floatvalue", "longvalue", "maxsize", "minsize"})
@JsonSerialize(using=EFCFloatJsonSerializer.class)
@JsonDeserialize(using=EFCFloatJsonDeserializer.class)
public class EFCFloat
extends NumberType {
    private static final long serialVersionUID = 2383458425192271472L;
    protected Double data = null;

    @Override
    public int hashCode() {
        return Objects.hash(this.data, this.isInitialized(), this.isModified());
    }

    public EFCFloat() {
    }

    public EFCFloat(Float d) {
        this();
        this.putValue(d);
    }

    public EFCFloat(Double d) {
        this();
        this.putValue(d);
    }

    public EFCFloat(String s) {
        this();
        this.putValue(s);
    }

    public EFCFloat(EFCString s) {
        this();
        this.putValue(s);
    }

    public EFCFloat(Integer i) {
        this();
        this.putValue(i);
    }

    public EFCFloat(Long l) {
        this();
        this.putValue(l);
    }

    public EFCFloat(EFCFloat val) {
        this();
        if (val != null) {
            this.data = val.data;
            this.putMetadata(val.getMetadata());
        }
    }

    @Override
    protected void nullData() {
        this.data = null;
        this.setUnInitialized();
    }

    @Override
    public boolean decimalsAllowed() {
        return true;
    }

    @Override
    public Object optainValue() {
        return this.data;
    }

    @Override
    public Float getFloatValue() {
        if (this.data == null) {
            return null;
        }
        return Float.valueOf(this.data.floatValue());
    }

    @Override
    public Double getDoubleValue() {
        if (this.data == null) {
            return null;
        }
        return this.data;
    }

    @Override
    public Long getLongValue() {
        if (this.data == null) {
            return null;
        }
        return this.data.longValue();
    }

    public double toDouble() {
        return this.data;
    }

    public void setData(Double newData) {
        if (newData != null && this.data != null && this.data.equals(newData)) {
            return;
        }
        this.data = newData;
        if (this.data != null) {
            this.setInitialized();
        } else {
            this.setUnInitialized();
        }
    }

    public Double getData() {
        return this.data;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EFCInteger) {
            return this.equals((EFCInteger)obj);
        }
        if (obj instanceof EFCLong) {
            return this.equals((EFCLong)obj);
        }
        if (obj instanceof EFCFloat) {
            return this.equals((EFCFloat)obj);
        }
        if (obj instanceof EFCString) {
            return this.equals((EFCString)obj);
        }
        return false;
    }

    @Override
    public final NumberType plus(byte v) {
        return new EFCFloat(this.getDoubleValue() + (double)v);
    }

    @Override
    public final NumberType plus(int v) {
        return new EFCFloat(this.getDoubleValue() + (double)v);
    }

    @Override
    public final NumberType plus(long v) {
        return new EFCFloat(this.getDoubleValue() + (double)v);
    }

    @Override
    public final NumberType plus(float v) {
        return new EFCFloat(this.getDoubleValue() + (double)v);
    }

    @Override
    public final NumberType plus(double v) {
        return new EFCFloat(this.getDoubleValue() + v);
    }

    @Override
    public final NumberType minus(byte v) {
        return new EFCFloat(this.getDoubleValue() - (double)v);
    }

    @Override
    public final NumberType minus(int v) {
        return new EFCFloat(this.getDoubleValue() - (double)v);
    }

    @Override
    public final NumberType minus(long v) {
        return new EFCFloat(this.getDoubleValue() - (double)v);
    }

    @Override
    public final NumberType minus(float v) {
        return new EFCFloat(this.getDoubleValue() - (double)v);
    }

    @Override
    public final NumberType minus(double v) {
        return new EFCFloat(this.getDoubleValue() - v);
    }

    @Override
    public final NumberType multiply(byte v) {
        return new EFCFloat(this.getDoubleValue() * (double)v);
    }

    @Override
    public final NumberType multiply(int v) {
        return new EFCFloat(this.getDoubleValue() * (double)v);
    }

    @Override
    public final NumberType multiply(long v) {
        return new EFCFloat(this.getDoubleValue() * (double)v);
    }

    @Override
    public final NumberType multiply(float v) {
        return new EFCFloat(this.getDoubleValue() * (double)v);
    }

    @Override
    public final NumberType multiply(double v) {
        return new EFCFloat(this.getDoubleValue() * v);
    }

    @Override
    public final NumberType div(byte v) {
        return new EFCFloat(this.getDoubleValue() / (double)v);
    }

    @Override
    public final NumberType div(int v) {
        return new EFCFloat(this.getDoubleValue() / (double)v);
    }

    @Override
    public final NumberType div(long v) {
        return new EFCFloat(this.getDoubleValue() / (double)v);
    }

    @Override
    public final NumberType div(float v) {
        return new EFCFloat(this.getDoubleValue() / (double)v);
    }

    @Override
    public final NumberType div(double v) {
        return new EFCFloat(this.getDoubleValue() / v);
    }

    @Override
    public final NumberType power(byte v) {
        return new EFCFloat(Math.pow(this.getDoubleValue(), v));
    }

    @Override
    public final NumberType power(int v) {
        return new EFCFloat(Math.pow(this.getDoubleValue(), v));
    }

    @Override
    public final NumberType power(long v) {
        return new EFCFloat(Math.pow(this.getDoubleValue(), v));
    }

    @Override
    public final NumberType power(float v) {
        return new EFCFloat(Math.pow(this.getDoubleValue(), v));
    }

    @Override
    public final NumberType power(double v) {
        return new EFCFloat(Math.pow(this.getDoubleValue(), v));
    }

    @Override
    public final NumberType mod(byte v) {
        return new EFCFloat(this.getDoubleValue() % (double)v);
    }

    @Override
    public final NumberType mod(int v) {
        return new EFCFloat(this.getDoubleValue() % (double)v);
    }

    @Override
    public final NumberType mod(long v) {
        return new EFCFloat(this.getDoubleValue() % (double)v);
    }

    @Override
    public final NumberType mod(float v) {
        return new EFCFloat(this.getDoubleValue() % (double)v);
    }

    @Override
    public final NumberType mod(double v) {
        return new EFCFloat(this.getDoubleValue() % v);
    }

    public EFCFloat clone() {
        return new EFCFloat(this);
    }

    @Override
    public void putValue(Object o) throws NumberFormatException {
        Object value;
        if (this == o) {
            return;
        }
        if (o == null) {
            this.nullData();
            return;
        }
        if (o instanceof Type && (value = ((Type)o).optainValue()) == null) {
            this.nullData();
            return;
        }
        if (o instanceof String || o instanceof EFCString) {
            String st = o instanceof EFCString ? ((EFCString)o).getData() : (String)o;
            if ("".equals(st = st.trim()) || "null".equals(st)) {
                this.nullData();
                return;
            }
            Number result = null;
            NumberFormat formaterWithSeparator = NumberFormat.getNumberInstance(Locale.US);
            NumberFormat formaterWithoutSeparator = NumberFormat.getNumberInstance(Locale.US);
            formaterWithSeparator.setGroupingUsed(true);
            formaterWithoutSeparator.setGroupingUsed(false);
            formaterWithSeparator.setParseIntegerOnly(!this.decimalsAllowed());
            formaterWithoutSeparator.setParseIntegerOnly(!this.decimalsAllowed());
            try {
                result = formaterWithSeparator.parse(st);
            }
            catch (ParseException nfex1) {
                try {
                    result = formaterWithoutSeparator.parse(st);
                }
                catch (ParseException nfex2) {
                    result = Double.valueOf(st);
                }
            }
            this.putValue(result);
            return;
        }
        if (o instanceof Integer) {
            this.setData(((Integer)o).doubleValue());
        } else if (o instanceof Long) {
            this.setData(((Long)o).doubleValue());
        } else if (o instanceof Float) {
            this.setData(((Float)o).doubleValue());
        } else if (o instanceof Double) {
            this.setData((Double)o);
        } else if (o instanceof EFCInteger) {
            this.setData(((EFCInteger)o).getDoubleValue());
        } else if (o instanceof EFCLong) {
            this.setData(((EFCLong)o).getDoubleValue());
        } else if (o instanceof EFCFloat) {
            this.setData(((EFCFloat)o).getDoubleValue());
        } else {
            throw new NumberFormatException("Integer, Long, Float, Double, String, or an EFCType based on those expected, not " + o.getClass().getName());
        }
        this.setInitialized();
    }

    @Override
    public void defaults() {
        this.setData(0.0);
    }

    @Override
    public String toString() {
        if (this.data != null) {
            return Double.toString(this.data);
        }
        return "";
    }

    @Override
    public long getMaxsize() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getMinsize() {
        return 0L;
    }

    @Override
    public void putMaxsize(long maxsize) {
        throw new RuntimeException("putMaxsize call not allowed");
    }

    @Override
    public void putMinsize(long minsize) {
        throw new RuntimeException("putMinsize call not allowed");
    }
}

