/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.EFCFloat;
import de.effectivecompany.base.datatypes.EFCLong;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.NumberType;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.datatypes.json.EFCIntegerJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCIntegerJsonSerializer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Objects;

@JsonIgnoreProperties(value={"maxsize", "minsize", "metadata", "init", "bytevalue", "doublevalue", "floatvalue", "intvalue", "longvalue"})
@JsonSerialize(using=EFCIntegerJsonSerializer.class)
@JsonDeserialize(using=EFCIntegerJsonDeserializer.class)
public class EFCInteger
extends NumberType {
    private static final long serialVersionUID = 4963602096856003496L;
    protected Integer data = null;

    @Override
    public int hashCode() {
        return Objects.hash(this.data, this.isInitialized(), this.isModified());
    }

    public EFCInteger() {
    }

    public EFCInteger(Integer i) {
        this();
        this.putValue(i);
    }

    public EFCInteger(String s) {
        this();
        this.putValue(s);
    }

    public EFCInteger(EFCString s) {
        this();
        this.putValue(s);
    }

    public EFCInteger(EFCInteger val) {
        this();
        if (val != null) {
            this.data = val.data;
            this.putMetadata(val.getMetadata());
        }
    }

    @Override
    protected void nullData() {
        this.data = null;
        this.setUnInitialized();
    }

    @Override
    public Object optainValue() {
        return this.data;
    }

    @Override
    public Integer getIntValue() {
        return this.data;
    }

    @Override
    public Long getLongValue() {
        if (this.data == null) {
            return null;
        }
        return (long)this.data;
    }

    @Override
    public Double getDoubleValue() {
        if (this.data == null) {
            return null;
        }
        return (double)this.data;
    }

    @Override
    public boolean decimalsAllowed() {
        return false;
    }

    @Override
    public String toString() {
        if (this.data == null) {
            return "";
        }
        return Integer.toString(this.data);
    }

    public Integer toInteger() {
        return this.data;
    }

    public long getMaximumSize() {
        return this.getMetadata().getMaxsize();
    }

    public long getMinimumSize() {
        return this.getMetadata().getMinsize();
    }

    public void setData(Integer newData) {
        if (newData != null && this.data != null && this.data.equals(newData)) {
            return;
        }
        this.data = newData;
        if (this.data != null) {
            this.setInitialized();
        } else {
            this.setUnInitialized();
        }
    }

    public Integer getData() {
        return this.data;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EFCInteger) {
            return this.equals((EFCInteger)obj);
        }
        if (obj instanceof EFCLong) {
            return this.equals((EFCLong)obj);
        }
        if (obj instanceof EFCFloat) {
            return this.equals((EFCFloat)obj);
        }
        if (obj instanceof EFCString) {
            return this.equals((EFCString)obj);
        }
        return false;
    }

    @Override
    public final NumberType plus(byte v) {
        return new EFCInteger(this.getIntValue() + v);
    }

    @Override
    public final NumberType plus(int v) {
        return new EFCInteger(this.getIntValue() + v);
    }

    @Override
    public final NumberType plus(long v) {
        return new EFCInteger(this.getIntValue() + (int)v);
    }

    @Override
    public final NumberType plus(float v) {
        return new EFCInteger(this.getIntValue() + (int)v);
    }

    @Override
    public final NumberType plus(double v) {
        return new EFCInteger(this.getIntValue() + (int)v);
    }

    @Override
    public final NumberType minus(byte v) {
        return new EFCInteger(this.getIntValue() - v);
    }

    @Override
    public final NumberType minus(int v) {
        return new EFCInteger(this.getIntValue() - v);
    }

    @Override
    public final NumberType minus(long v) {
        return new EFCInteger(this.getIntValue() - (int)v);
    }

    @Override
    public final NumberType minus(float v) {
        return new EFCInteger(this.getIntValue() - (int)v);
    }

    @Override
    public final NumberType minus(double v) {
        return new EFCInteger(this.getIntValue() - (int)v);
    }

    @Override
    public final NumberType multiply(byte v) {
        return new EFCInteger(this.getIntValue() * v);
    }

    @Override
    public final NumberType multiply(int v) {
        return new EFCInteger(this.getIntValue() * v);
    }

    @Override
    public final NumberType multiply(long v) {
        return new EFCInteger(this.getIntValue() * (int)v);
    }

    @Override
    public final NumberType multiply(float v) {
        return new EFCInteger(this.getIntValue() * (int)v);
    }

    @Override
    public final NumberType multiply(double v) {
        return new EFCInteger(this.getIntValue() * (int)v);
    }

    @Override
    public final NumberType div(byte v) {
        return new EFCInteger(this.getIntValue() / v);
    }

    @Override
    public final NumberType div(int v) {
        return new EFCInteger(this.getIntValue() / v);
    }

    @Override
    public final NumberType div(long v) {
        return new EFCInteger(this.getIntValue() / (int)v);
    }

    @Override
    public final NumberType div(float v) {
        return new EFCInteger((int)((float)this.getIntValue().intValue() / v));
    }

    @Override
    public final NumberType div(double v) {
        return new EFCInteger((int)((double)this.getIntValue().intValue() / v));
    }

    @Override
    public final NumberType power(byte v) {
        return new EFCInteger((int)Math.pow(this.getIntValue().intValue(), v));
    }

    @Override
    public final NumberType power(int v) {
        return new EFCInteger((int)Math.pow(this.getIntValue().intValue(), v));
    }

    @Override
    public final NumberType power(long v) {
        return new EFCInteger((int)Math.pow(this.getIntValue().intValue(), v));
    }

    @Override
    public final NumberType power(float v) {
        return new EFCInteger((int)Math.pow(this.getIntValue().intValue(), v));
    }

    @Override
    public final NumberType power(double v) {
        return new EFCInteger((int)Math.pow(this.getIntValue().intValue(), v));
    }

    @Override
    public final NumberType mod(byte v) {
        return new EFCInteger(this.getIntValue() % v);
    }

    @Override
    public final NumberType mod(int v) {
        return new EFCInteger(this.getIntValue() % v);
    }

    @Override
    public final NumberType mod(long v) {
        return new EFCInteger((int)((long)this.getIntValue().intValue() % v));
    }

    @Override
    public final NumberType mod(float v) {
        return new EFCInteger((int)((float)this.getIntValue().intValue() % v));
    }

    @Override
    public NumberType mod(double v) {
        return new EFCInteger((int)((double)this.getIntValue().intValue() % v));
    }

    public EFCInteger clone() {
        return new EFCInteger(this);
    }

    @Override
    public void putValue(Object o) throws NumberFormatException {
        Object value;
        if (this == o) {
            return;
        }
        if (o == null) {
            this.nullData();
            return;
        }
        if (o instanceof Type && (value = ((Type)o).optainValue()) == null) {
            this.nullData();
            return;
        }
        if (o instanceof String || o instanceof EFCString) {
            String st = o instanceof EFCString ? ((EFCString)o).getData() : (String)o;
            if ("".equals(st = st.trim()) || "null".equals(st)) {
                this.nullData();
                return;
            }
            Number result = null;
            NumberFormat formaterWithSeparator = NumberFormat.getNumberInstance();
            NumberFormat formaterWithoutSeparator = NumberFormat.getNumberInstance();
            formaterWithSeparator.setGroupingUsed(true);
            formaterWithoutSeparator.setGroupingUsed(false);
            formaterWithSeparator.setParseIntegerOnly(!this.decimalsAllowed());
            formaterWithoutSeparator.setParseIntegerOnly(!this.decimalsAllowed());
            try {
                result = formaterWithSeparator.parse(st);
                if (result.longValue() > Integer.MAX_VALUE || result.longValue() < Integer.MIN_VALUE) {
                    throw new IllegalArgumentException("value out of integer bounds");
                }
                result = result.intValue();
            }
            catch (ParseException nfex1) {
                try {
                    result = formaterWithoutSeparator.parse(st);
                }
                catch (ParseException nfex2) {
                    result = Double.valueOf(st);
                }
            }
            this.putValue(result);
            return;
        }
        if (o instanceof Integer) {
            this.setData((Integer)o);
        } else if (o instanceof EFCInteger) {
            this.setData((int)((EFCInteger)o).getIntValue());
        } else {
            throw new NumberFormatException("Integer, Long, Float, Double, String, or an EFCType based on those expected, not " + o.getClass().getName());
        }
        this.setInitialized();
    }

    @Override
    public void defaults() {
        this.setData(0);
    }

    @Override
    public long getMaxsize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getMinsize() {
        return Integer.MIN_VALUE;
    }

    @Override
    public void putMaxsize(long maxsize) {
        throw new RuntimeException("putMaxsize call not allowed");
    }

    @Override
    public void putMinsize(long minsize) {
        throw new RuntimeException("putMinsize call not allowed");
    }
}

