/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.esotericsoftware.kryo.Kryo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.effectivecompany.base.datatypes.Metadata;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.util.SerializationUtilities;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

@JsonIgnoreProperties(value={"metadata", "init"})
public class EFCSet<E>
extends ConcurrentSkipListSet<E>
implements Type,
Set<E>,
Metadata {
    private static final long serialVersionUID = -3275700013699424653L;
    private boolean initialized = false;
    private boolean modified = false;

    public EFCSet() {
    }

    public EFCSet(EFCSet<E> val) {
        if (val != null) {
            this.addAll(val.clone());
            this.initialized = val.isInitialized();
            this.modified = val.isModified();
        }
    }

    public EFCSet(Collection<E> val) {
        if (val != null) {
            Kryo kryo = SerializationUtilities.optainKryo();
            Collection deepCopyData = (Collection)kryo.copy(val);
            SerializationUtilities.freeKryo(kryo);
            this.addAll(deepCopyData);
            this.initialized = true;
            this.modified = true;
        }
    }

    @Override
    public long getMaxsize() {
        return this.size();
    }

    @Override
    public void putMaxsize(long maxsize) {
        throw new RuntimeException("putMaxsize call not allowed");
    }

    @Override
    public long getMinsize() {
        return this.size();
    }

    @Override
    public void putMinsize(long minsize) {
        throw new RuntimeException("putMinsize call not allowed");
    }

    @Override
    public boolean isInit() {
        return this.initialized;
    }

    @Override
    public void putInit(boolean isInit) {
        this.initialized = isInit;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void putModified(boolean isModified) {
        this.initialized = isModified;
    }

    public void setInitialized() {
        this.putInit(true);
    }

    public void setUnInitialized() {
        this.putInit(false);
    }

    public boolean isInitialized() {
        return this.isInit();
    }

    @Override
    public Metadata getMetadata() {
        return this;
    }

    @Override
    public void putValue(Object o) {
        if (this == o) {
            return;
        }
        if (!(o instanceof Collection)) {
            throw new IllegalArgumentException("value has to be a collection");
        }
        this.clear();
        this.addAll((Collection)o);
    }

    @Override
    public Object optainValue() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Collection) {
            Collection l = (Collection)o;
            if (l.size() != this.size()) {
                return false;
            }
            Iterator it1 = this.iterator();
            Iterator it2 = l.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                Object o1 = it1.next();
                Object o2 = it2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return !it1.hasNext() && !it2.hasNext();
        }
        return super.equals(o);
    }

    @Override
    public EFCSet<E> clone() {
        Kryo kryo = SerializationUtilities.optainKryo();
        EFCSet ret = (EFCSet)kryo.copy((Object)this);
        SerializationUtilities.freeKryo(kryo);
        return ret;
    }
}

