/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import de.effectivecompany.base.datatypes.BaseType;
import de.effectivecompany.base.datatypes.EFCAlphaNumeric;
import de.effectivecompany.base.datatypes.EFCFloat;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCLong;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.Metadata;

public abstract class NumberType
extends BaseType
implements Comparable<NumberType> {
    private static final long serialVersionUID = 1161285040972362515L;

    @Override
    public abstract void putValue(Object var1) throws NumberFormatException;

    public Byte getByteValue() {
        if (this.getIntValue() == null) {
            return null;
        }
        return this.getIntValue().byteValue();
    }

    public Integer getIntValue() {
        if (this.getLongValue() == null) {
            return null;
        }
        return this.getLongValue().intValue();
    }

    public abstract Long getLongValue();

    public Float getFloatValue() {
        if (this.getDoubleValue() == null) {
            return null;
        }
        return Float.valueOf(this.getDoubleValue().floatValue());
    }

    public abstract Double getDoubleValue();

    public abstract boolean decimalsAllowed();

    public abstract String toString();

    public NumberType plus(EFCInteger v) {
        return this.plus(v.getIntValue());
    }

    public NumberType plus(EFCLong v) {
        return this.plus(v.getLongValue());
    }

    public NumberType plus(EFCFloat v) {
        return this.plus(v.getDoubleValue());
    }

    public abstract NumberType plus(byte var1);

    public abstract NumberType plus(int var1);

    public abstract NumberType plus(long var1);

    public abstract NumberType plus(float var1);

    public abstract NumberType plus(double var1);

    public NumberType minus(EFCInteger v) {
        return this.plus(v.getIntValue());
    }

    public NumberType minus(EFCLong v) {
        return this.minus(v.getLongValue());
    }

    public NumberType minus(EFCFloat v) {
        return this.minus(v.getDoubleValue());
    }

    public abstract NumberType minus(byte var1);

    public abstract NumberType minus(int var1);

    public abstract NumberType minus(long var1);

    public abstract NumberType minus(float var1);

    public abstract NumberType minus(double var1);

    public NumberType multiply(EFCInteger v) {
        return this.multiply(v.getIntValue());
    }

    public NumberType multiply(EFCLong v) {
        return this.multiply(v.getLongValue());
    }

    public NumberType multiply(EFCFloat v) {
        return this.multiply(v.getDoubleValue());
    }

    public abstract NumberType multiply(byte var1);

    public abstract NumberType multiply(int var1);

    public abstract NumberType multiply(long var1);

    public abstract NumberType multiply(float var1);

    public abstract NumberType multiply(double var1);

    public NumberType div(EFCInteger v) {
        return this.div(v.getIntValue());
    }

    public NumberType div(EFCLong v) {
        return this.div(v.getLongValue());
    }

    public NumberType div(EFCFloat v) {
        return this.div(v.getDoubleValue());
    }

    public abstract NumberType div(byte var1);

    public abstract NumberType div(int var1);

    public abstract NumberType div(long var1);

    public abstract NumberType div(float var1);

    public abstract NumberType div(double var1);

    public NumberType power(EFCInteger v) {
        return this.power(v.getIntValue());
    }

    public NumberType power(EFCLong v) {
        return this.power(v.getLongValue());
    }

    public NumberType power(EFCFloat v) {
        return this.power(v.getDoubleValue());
    }

    public abstract NumberType power(byte var1);

    public abstract NumberType power(int var1);

    public abstract NumberType power(long var1);

    public abstract NumberType power(float var1);

    public abstract NumberType power(double var1);

    public NumberType mod(EFCInteger v) {
        return this.mod(v.getIntValue());
    }

    public NumberType mod(EFCLong v) {
        return this.mod(v.getLongValue());
    }

    public NumberType mod(EFCFloat v) {
        return this.mod(v.getDoubleValue());
    }

    public abstract NumberType mod(byte var1);

    public abstract NumberType mod(int var1);

    public abstract NumberType mod(long var1);

    public abstract NumberType mod(float var1);

    public abstract NumberType mod(double var1);

    public abstract boolean equals(Object var1);

    public boolean equals(EFCInteger v) {
        if (v == null) {
            return false;
        }
        if (this.getIntValue() == null && (v == null || v.getIntValue() == null)) {
            return true;
        }
        if (this.getIntValue() == null || v.getIntValue() == null) {
            return false;
        }
        return this.getIntValue().equals(v.getIntValue());
    }

    public boolean equals(EFCLong v) {
        if (v == null) {
            return false;
        }
        if (this.getLongValue() == null && (v == null || v.getLongValue() == null)) {
            return true;
        }
        if (this.getLongValue() == null || v.getLongValue() == null) {
            return false;
        }
        return this.getLongValue().equals(v.getLongValue());
    }

    public boolean equals(EFCFloat v) {
        if (v == null) {
            return false;
        }
        if (this.getDoubleValue() == null && (v == null || v.getDoubleValue() == null)) {
            return true;
        }
        if (this.getDoubleValue() == null || v.getDoubleValue() == null) {
            return false;
        }
        return this.getDoubleValue().equals(v.getDoubleValue());
    }

    public boolean equals(byte v) {
        return this.getByteValue() == v;
    }

    public boolean equals(int v) {
        return this.getIntValue() == v;
    }

    public boolean equals(long v) {
        return this.getLongValue() == v;
    }

    public boolean equals(float v) {
        return this.getDoubleValue() == (double)v;
    }

    public boolean equals(double v) {
        return this.getDoubleValue() == v;
    }

    public boolean equals(EFCString v) {
        if (v == null) {
            return false;
        }
        return this.equals(v.getData());
    }

    public boolean equals(EFCAlphaNumeric v) {
        if (v == null) {
            return false;
        }
        return this.equals(v.getData());
    }

    public boolean equals(String v) {
        Long l;
        try {
            l = Long.valueOf(v);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return this.getLongValue().equals(l);
    }

    @Override
    public int compareTo(EFCInteger v) {
        Integer val = this.getIntValue();
        if (val == null) {
            if (v == null || v.optainValue() == null) {
                return 0;
            }
            return -1;
        }
        if (v == null || v.optainValue() == null) {
            return 1;
        }
        return val.compareTo(v.getIntValue());
    }

    @Override
    public int compareTo(EFCLong v) {
        Long val = this.getLongValue();
        if (val == null) {
            if (v == null || v.optainValue() == null) {
                return 0;
            }
            return -1;
        }
        if (v == null || v.optainValue() == null) {
            return 1;
        }
        return val.compareTo(v.getLongValue());
    }

    @Override
    public int compareTo(EFCFloat v) {
        Float val = this.getFloatValue();
        if (val == null) {
            if (v == null || v.optainValue() == null) {
                return 0;
            }
            return -1;
        }
        if (v == null || v.optainValue() == null) {
            return 1;
        }
        return val.compareTo(v.getFloatValue());
    }

    @Override
    public int compareTo(NumberType v) {
        if (this.optainValue() == null) {
            if (v == null || v.optainValue() == null) {
                return 0;
            }
            return -1;
        }
        if (v == null || v.optainValue() == null) {
            return 1;
        }
        if (v instanceof EFCInteger) {
            return this.compareTo((EFCInteger)v);
        }
        if (v instanceof EFCLong) {
            return this.compareTo((EFCLong)v);
        }
        if (v instanceof EFCFloat) {
            return this.compareTo((EFCFloat)v);
        }
        return this.getDoubleValue().compareTo(v.getDoubleValue());
    }

    @Override
    public int compareTo(byte v) {
        return this.getByteValue().compareTo(v);
    }

    @Override
    public int compareTo(int v) {
        return this.getIntValue().compareTo(v);
    }

    @Override
    public int compareTo(Integer v) {
        if (v == null) {
            return this.compareTo(0);
        }
        return this.getIntValue().compareTo(v);
    }

    @Override
    public int compareTo(long v) {
        return this.getLongValue().compareTo(v);
    }

    @Override
    public int compareTo(Long v) {
        if (v == null) {
            return this.compareTo(0);
        }
        return this.getLongValue().compareTo(v);
    }

    @Override
    public int compareTo(float v) {
        return this.getFloatValue().compareTo(Float.valueOf(v));
    }

    @Override
    public int compareTo(Float v) {
        if (v == null) {
            return this.compareTo(0);
        }
        return this.getFloatValue().compareTo(v);
    }

    @Override
    public int compareTo(double v) {
        return this.getDoubleValue().compareTo(v);
    }

    @Override
    public int compareTo(Double v) {
        if (v == null) {
            return this.compareTo(0);
        }
        return this.getDoubleValue().compareTo(v);
    }

    @Override
    public int compareTo(EFCString v) {
        if (v == null) {
            return this.compareTo(0);
        }
        return this.compareTo(v.getData());
    }

    @Override
    public int compareTo(EFCAlphaNumeric v) {
        if (v == null) {
            return this.compareTo(0);
        }
        return this.compareTo(v.getData());
    }

    @Override
    public int compareTo(String v) {
        Long l;
        try {
            l = Long.valueOf(v);
        }
        catch (NumberFormatException ex) {
            return this.compareTo(0);
        }
        return this.getLongValue().compareTo(l);
    }

    public void putMetadata(Metadata meta) {
        this.putInit(meta.isInit());
        this.putModified(meta.isModified());
    }
}

