/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.json.Utils;
import java.io.IOException;

public class EFCMapJsonSerializer
extends JsonSerializer<EFCMap<?, ?>> {
    public void serialize(EFCMap<?, ?> obj, JsonGenerator jgen, SerializerProvider arg2) throws IOException, JsonProcessingException {
        if (obj != null && obj.size() >= 0) {
            jgen.writeStartObject();
            jgen.writeArrayFieldStart("data");
            String valueType = null;
            String keyType = null;
            for (Object k : obj.keySet()) {
                jgen.writeStartObject();
                jgen.writeObjectField("k", k);
                jgen.writeObjectField("v", obj.get(k));
                jgen.writeEndObject();
                if (valueType == null && obj.get(k) != null) {
                    valueType = obj.get(k).getClass().getName();
                }
                if (keyType != null) continue;
                keyType = k.getClass().getName();
            }
            jgen.writeEndArray();
            Utils.writeBaseAttributes(jgen, obj);
            if (valueType != null) {
                jgen.writeStringField("javaValueType", valueType);
            }
            if (keyType != null) {
                jgen.writeStringField("javaKeyType", keyType);
            }
            jgen.writeEndObject();
        } else {
            jgen.writeNull();
        }
    }
}

