/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.efcbl.error;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.efcbl.error.ApplicationExceptionJsonSerializer;
import de.effectivecompany.base.msg.Msg;
import de.effectivecompany.base.msg.MsgList;
import de.effectivecompany.base.msg.MsgType;
import java.util.Iterator;

@JsonIgnoreProperties(value={"backtrace", "detailMessage", "cause", "stackTrace", "localizedMessage", "message"})
@JsonSerialize(using=ApplicationExceptionJsonSerializer.class)
public class ApplicationException
extends RuntimeException {
    private static final long serialVersionUID = 1596208156393065408L;
    private boolean logged;
    private MsgList msgList = new MsgList();

    public ApplicationException(ApplicationException e) {
        this.logged = e.logged;
        Iterator<Msg> iter = e.getMsgList().iterator();
        while (iter.hasNext()) {
            this.msgList.addMsg(iter.next());
        }
    }

    public ApplicationException(Msg msg) {
        this.msgList.addMsg(msg);
    }

    public ApplicationException(MsgList list) {
        this.msgList = list;
    }

    public ApplicationException(String number, String msg) {
    }

    public boolean isFatal() {
        return this.msgList.getMaxSeverity() == MsgType.FATAL;
    }

    public boolean isLogged() {
        return this.logged;
    }

    public void setLogged(boolean logged) {
        this.logged = logged;
    }

    public String getErrorCode() {
        if (this.msgList.getMsgList().size() == 0) {
            return "NO CODE";
        }
        if (this.msgList.getMsgList().size() == 1) {
            return Integer.toString(this.msgList.getMsgList().get(0).getMsg().getMsgNumber());
        }
        return "MULTIPLE CODES";
    }

    public boolean hasMultipleMsgs() {
        return this.msgList.getMsgList().size() > 1;
    }

    @Override
    public String getMessage() {
        return this.msgList.toString();
    }

    public Msg getLastMsg() {
        return this.msgList.getMsgList().get(0);
    }

    public MsgList getMsgList() {
        return this.msgList;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[#:" + this.getErrorCode() + "]:" + this.getMessage();
    }

    public String getJavaMessage() {
        return super.getMessage();
    }
}

