/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.gui.data;

import de.effectivecompany.base.gui.data.SearchResult;
import de.effectivecompany.base.gui.key.Key;
import java.awt.Color;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SearchResultImpl
implements SearchResult,
Serializable {
    private static final long serialVersionUID = -4404597942817140408L;
    private final Map<String, String> data;
    private final Key key;
    private Color _color = Color.white;
    private Map<String, Color> _colorMap = null;

    public SearchResultImpl(Map<String, String> data, Key key) {
        this.data = data;
        this.key = key;
    }

    @Override
    public Map<String, String> getData() {
        return this.data;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public Color getColor() {
        return this._color;
    }

    @Override
    public void setColor(Color color) {
        this._color = color;
    }

    @Override
    public synchronized Map<String, Color> getColorMap() {
        if (this._colorMap == null) {
            this._colorMap = new ConcurrentHashMap<String, Color>();
        }
        return this._colorMap;
    }

    public synchronized void setColorMap(Map<String, Color> map) {
        this._colorMap = map;
    }

    @Override
    public void putAttrColor(String attributeName, Color attributeColor) {
        if (this._colorMap == null) {
            this._colorMap = this.getColorMap();
        }
        this._colorMap.put(attributeName, attributeColor);
    }

    @Override
    public Color getAttrColor(String attributeName) {
        Color ret = null;
        if (this._colorMap != null) {
            ret = this._colorMap.get(attributeName);
        }
        if (ret == null) {
            ret = Color.white;
        }
        return ret;
    }
}

