/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.gui.filter;

import de.effectivecompany.base.gui.filter.FilterCriteria;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Filter
implements Serializable {
    private static final long serialVersionUID = -2241432686839272686L;
    private List<FilterCriteria> criterias;
    private List<Filter> subfilter;
    private int type;
    private boolean not = false;
    private String orderbyfield = null;
    private String orderbytype = null;
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int XOR = 3;
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";

    public Filter() {
        this(1);
    }

    public Filter(String xml) throws SAXException, ParserConfigurationException, IOException {
        this(new ByteArrayInputStream(xml.getBytes()));
    }

    public Filter(InputStream xmldef) throws SAXException, ParserConfigurationException, IOException {
        this(1);
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmldef);
        Element node = doc.getDocumentElement();
        if (node.getAttributes().getNamedItem("type").getTextContent().equalsIgnoreCase("XOR")) {
            this.setType(3);
        } else if (node.getAttributes().getNamedItem("type").getTextContent().equalsIgnoreCase("AND")) {
            this.setType(1);
        } else {
            this.setType(2);
        }
        if (node.getAttributes().getNamedItem("orderbyfield") != null) {
            this.setOrderbyfield(node.getAttributes().getNamedItem("orderbyfield").getTextContent());
        }
        if (node.getAttributes().getNamedItem("orderbytype") != null) {
            this.setOrderbytype(node.getAttributes().getNamedItem("orderbytype").getTextContent());
        }
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeName().equalsIgnoreCase("filter")) {
                this.addSubfilter(new Filter(n));
                continue;
            }
            if (!n.getNodeName().equalsIgnoreCase("criteria")) continue;
            this.addCriteria(new FilterCriteria(n));
        }
    }

    private Filter(Node node) throws SAXException, ParserConfigurationException, IOException {
        this(1);
        if (node.getAttributes().getNamedItem("type").getTextContent().equalsIgnoreCase("XOR")) {
            this.setType(3);
        } else if (node.getAttributes().getNamedItem("type").getTextContent().equalsIgnoreCase("AND")) {
            this.setType(1);
        } else {
            this.setType(2);
        }
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeName().equalsIgnoreCase("filter")) {
                this.addSubfilter(new Filter(n));
                continue;
            }
            if (!n.getNodeName().equalsIgnoreCase("criteria")) continue;
            this.addCriteria(new FilterCriteria(n));
        }
    }

    public Filter(int type) {
        this.type = type;
        this.criterias = new LinkedList<FilterCriteria>();
        this.subfilter = new LinkedList<Filter>();
    }

    public int addCriteria(FilterCriteria criteria) {
        this.criterias.add(criteria);
        return this.criterias.size() - 1;
    }

    public FilterCriteria getCriteria(int id) {
        return this.criterias.get(id);
    }

    public void removeCriteria(int id) {
        this.criterias.remove(id);
    }

    public int getCriteriaSize() {
        return this.criterias.size();
    }

    public int addSubfilter(Filter filter) {
        this.subfilter.add(filter);
        return this.subfilter.size() - 1;
    }

    public Filter getSubfilter(int id) {
        return this.subfilter.get(id);
    }

    public void removeSubfilter(int id) {
        this.subfilter.remove(id);
    }

    public int getSubfilterSize() {
        return this.subfilter.size();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setNot(boolean not) {
        this.not = not;
    }

    public boolean isNot() {
        return this.not;
    }

    public String getAsXML() {
        StringBuffer buf = new StringBuffer();
        String type = "?";
        switch (this.getType()) {
            case 1: {
                type = "AND";
                break;
            }
            case 3: {
                type = "XOR";
                break;
            }
            case 2: {
                type = "OR";
            }
        }
        buf.append("<filter type=\"" + type + "\"");
        if (this.getOrderbyfield() != null) {
            buf.append(" orderbyfield=\"" + this.getOrderbyfield() + "\"");
            if (this.getOrderbytype() != null) {
                buf.append(" orderbytype=\"" + this.getOrderbytype() + "\"");
            }
        }
        buf.append(">\n");
        for (Filter f : this.subfilter) {
            buf.append(f.getAsXML() + "\n");
        }
        for (FilterCriteria c : this.criterias) {
            buf.append(c.getAsXML() + "\n");
        }
        buf.append("</filter>");
        return buf.toString();
    }

    public String toString() {
        String type = "?";
        switch (this.getType()) {
            case 1: {
                type = "AND";
                break;
            }
            case 3: {
                type = "XOR";
                break;
            }
            case 2: {
                type = "OR";
            }
        }
        Object st = "(\n";
        boolean next = false;
        for (Filter f : this.subfilter) {
            st = (String)st + (String)(next ? "\t" + type + " " : "\t") + f.toString();
            next = true;
        }
        for (FilterCriteria c : this.criterias) {
            st = (String)st + (String)(next ? "\t" + type + " " : "\t") + c.toString();
            next = true;
        }
        st = (String)st + ")\n";
        return st;
    }

    public String getOrderbyfield() {
        return this.orderbyfield;
    }

    public void setOrderbyfield(String orderbyfield) {
        this.orderbyfield = orderbyfield;
    }

    public String getOrderbytype() {
        return this.orderbytype;
    }

    public void setOrderbytype(String orderbytype) {
        this.orderbytype = orderbytype;
    }
}

