/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.gui.swing;

import de.effectivecompany.base.security.SecUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class EFCLoginDialog
extends JPanel {
    private static final long serialVersionUID = -2421485161280202090L;
    private static JButton okButton = new JButton("Login");
    private static JButton cancelButton = new JButton("Cancel");
    private static Object[] ConnectOptionNames = new Object[]{okButton, cancelButton};
    private static String ConnectTitle = "Effective Company";
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JTextField companyField;
    private JLabel userLabel;
    private JLabel passwordLabel;
    private JLabel companyLabel;
    private JLabel statusInfoLabel;
    private EnterKeyhandler enterHandler;
    private static UsernamePasswordAuthenticationToken token;
    private static JDialog dialog;

    public EFCLoginDialog(String i_lastUser, String i_lastCompany) {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(280, 85));
        this.userLabel = new JLabel("Benutzername:", 2);
        this.userLabel.setBounds(0, 0, 80, 20);
        this.add(this.userLabel);
        this.enterHandler = new EnterKeyhandler();
        this.usernameField = new JTextField(i_lastUser);
        this.usernameField.setBounds(80, 0, 140, 20);
        this.usernameField.addKeyListener(this.enterHandler);
        this.add(this.usernameField);
        this.passwordLabel = new JLabel("Password:", 2);
        this.passwordLabel.setBounds(0, 20, 80, 20);
        this.add(this.passwordLabel);
        this.passwordField = new JPasswordField("");
        this.passwordField.setBounds(80, 20, 140, 20);
        this.passwordField.addKeyListener(this.enterHandler);
        this.add(this.passwordField);
        this.companyLabel = new JLabel("Firma:", 2);
        this.companyLabel.setBounds(0, 40, 80, 20);
        this.add(this.companyLabel);
        this.companyField = new JTextField(i_lastCompany);
        this.companyField.setBounds(80, 40, 60, 20);
        this.companyField.addKeyListener(this.enterHandler);
        this.add(this.companyField);
        this.companyLabel.setVisible(false);
        this.companyField.setVisible(false);
        this.statusInfoLabel = new JLabel();
        this.statusInfoLabel.setBounds(0, 60, 250, 20);
        this.add(this.statusInfoLabel);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String username = SecUtils.encodeUserAndCompany(EFCLoginDialog.this.usernameField.getText().trim(), EFCLoginDialog.this.companyField.getText().trim());
                String password = SecUtils.encodePassword(new String(EFCLoginDialog.this.passwordField.getPassword()));
                token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
                JOptionPane.getRootFrame().dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
    }

    public static Authentication getAuthentication(String lastUser, String lastCompany) {
        return EFCLoginDialog.getAuthentication(lastUser, lastCompany, new EFCLoginDialog(lastUser, lastCompany));
    }

    public static Authentication getAuthentication(String lastUser, String lastCompany, Component parent) {
        return EFCLoginDialog.getAuthentication(lastUser, lastCompany, new EFCLoginDialog(lastUser, lastCompany), parent);
    }

    public static Authentication getAuthentication(String lastUser, String lastCompany, EFCLoginDialog dlg, Component parent) {
        SecurityContextHolder.setStrategyName((String)"MODE_GLOBAL");
        dlg.requestFocusInWindow();
        if (dialog == null) {
            JOptionPane optionPane = new JOptionPane();
            optionPane.setMessage(dlg);
            optionPane.setMessageType(3);
            optionPane.setOptionType(2);
            optionPane.setOptions(ConnectOptionNames);
            optionPane.setInitialValue(dlg.usernameField);
            dialog = new JDialog();
            dialog.setModal(true);
            dialog.setTitle(ConnectTitle);
            try {
                dialog.setIconImage(new ImageIcon(EFCLoginDialog.class.getResource("/png/icon_window_wug.png")).getImage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dialog.setContentPane(optionPane);
            dialog.setDefaultCloseOperation(0);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            dialog.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = dialog.getPreferredSize();
            dialog.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        }
        dialog.setVisible(true);
        dlg = null;
        return token;
    }

    public void terminate() {
        this.removeAll();
        for (ActionListener actionListener : cancelButton.getActionListeners()) {
            cancelButton.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : okButton.getActionListeners()) {
            okButton.removeActionListener(actionListener);
        }
        okButton = null;
        cancelButton = null;
        ConnectOptionNames = null;
        this.usernameField.removeKeyListener(this.enterHandler);
        this.passwordField.removeKeyListener(this.enterHandler);
        this.companyField.removeKeyListener(this.enterHandler);
        this.usernameField = null;
        this.passwordField = null;
        this.companyField = null;
        this.userLabel = null;
        this.passwordLabel = null;
        this.companyLabel = null;
        this.enterHandler = null;
        token = null;
        for (EventListener eventListener : dialog.getWindowListeners()) {
            dialog.removeWindowListener((WindowListener)eventListener);
        }
        Container con = dialog.getContentPane();
        con.removeAll();
        con = null;
        dialog.removeAll();
        dialog.dispose();
        dialog = null;
    }

    public void setLabelFont(Font font) {
        this.userLabel.setFont(font);
        this.passwordLabel.setFont(font);
        this.companyLabel.setFont(font);
    }

    public Font getLabelFont() {
        return this.userLabel.getFont();
    }

    public void setFormFont(Font font) {
        this.usernameField.setFont(font);
        this.passwordField.setFont(font);
        this.companyField.setFont(font);
    }

    public Font getFormFont() {
        return this.usernameField.getFont();
    }

    public JLabel getStatusInfoLabel() {
        return this.statusInfoLabel;
    }

    public void setStartFocus() {
        this.usernameField.requestFocusInWindow();
    }

    private class EnterKeyhandler
    extends KeyAdapter {
        private EnterKeyhandler() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyChar() == '\n') {
                if ((JComponent)event.getSource() instanceof JPasswordField) {
                    okButton.doClick();
                } else {
                    ((JComponent)event.getSource()).transferFocus();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }
    }
}

