/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.i18n;

import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;

public class MergeResourceBundle
extends ResourceBundle {
    private ResourceBundle defaultBundle;
    private ResourceBundle overwriteByBundle;

    public MergeResourceBundle(ResourceBundle defaultBundle, ResourceBundle overwriteByBundle) {
        if (defaultBundle == null || overwriteByBundle == null) {
            throw new InvalidParameterException("defaultBundle and/or overwriteByBundle is null!!!");
        }
        this.defaultBundle = defaultBundle;
        this.overwriteByBundle = overwriteByBundle;
    }

    public Enumeration getKeys() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(Collections.list(this.defaultBundle.getKeys()));
        set.addAll(Collections.list(this.overwriteByBundle.getKeys()));
        return Collections.enumeration(set);
    }

    @Override
    protected Object handleGetObject(String key) {
        Object ret = null;
        try {
            ret = this.overwriteByBundle.getObject(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null) {
            try {
                ret = this.defaultBundle.getObject(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }
}

