/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.i18n;

import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class Translator {
    private static Logger logger = LoggerFactory.getLogger(Translator.class);
    public static final String LOG_I18N_NAME = "de.effectivecompany.i18n";
    private static I18n i18n = null;

    public static void setI18n(I18n i18nSv) {
        i18n = i18nSv;
    }

    public static I18n getI18n() {
        return i18n;
    }

    public static boolean setLocale(Locale locale) {
        if (i18n != null) {
            return i18n.setLocale(locale);
        }
        logger.debug("no i18n service set, gettext support disabled");
        return false;
    }

    public static Locale getLocale() {
        if (i18n != null) {
            return i18n.getLocale();
        }
        logger.debug("no i18n service set, gettext support disabled");
        return null;
    }

    public static String tr(String text) {
        if (i18n != null) {
            String testtext = i18n.tr(text);
            if (!testtext.equals(text)) {
                return testtext;
            }
            logger.debug("i18n service has no entry for '" + text + "'");
        } else {
            logger.debug("no i18n service set, gettext support disabled");
        }
        return text;
    }

    public static String tr(String text, Object value) {
        if (i18n != null) {
            String testtext = i18n.tr(text, value);
            if (!testtext.equals(text)) {
                return testtext;
            }
            logger.debug("NOTICE: i18n service has no entry for '" + text + "'");
            return testtext;
        }
        logger.debug("NOTICE: no i18n service set, gettext support disabled");
        return text;
    }

    public static String tr(String text, List<?> values) {
        if (values != null) {
            return Translator.tr(text, values.toArray());
        }
        return Translator.tr(text, new Object[0]);
    }

    public static String tr(String text, Object[] values) {
        if (i18n != null) {
            String testtext = i18n.tr(text, values);
            if (!testtext.equals(text)) {
                return testtext;
            }
            logger.debug("i18n service has no entry for '" + text + "'");
            return testtext;
        }
        logger.debug("NOTICE: no i18n service set, gettext support disabled");
        return text;
    }

    public static String trn(String singularText, String pluralText, int count) {
        if (i18n != null) {
            String testtext = i18n.trn(singularText, pluralText, (long)count);
            logger.debug("i18n service has no entry for '" + singularText + "'");
            return testtext;
        }
        logger.debug("NOTICE: no i18n service set, gettext support disabled");
        return singularText;
    }

    public static String trn(String singularText, String pluralText, int count, Object value) {
        if (i18n != null) {
            String testtext = i18n.trn(singularText, pluralText, (long)count, value);
            logger.debug("i18n service has no entry for '" + singularText + "'");
            return testtext;
        }
        logger.debug("NOTICE: no i18n service set, gettext support disabled");
        return singularText;
    }

    public static String trn(String singularText, String pluralText, int count, List<Object> values) {
        if (values != null) {
            return Translator.trn(singularText, pluralText, count, values.toArray());
        }
        return Translator.trn(singularText, pluralText, count, new Object[0]);
    }

    public static String trn(String singularText, String pluralText, int count, Object[] values) {
        if (i18n != null) {
            String testtext = i18n.trn(singularText, pluralText, (long)count, values);
            logger.debug("i18n service has no entry for '" + singularText + "'");
            return testtext;
        }
        logger.debug("NOTICE: no i18n service set, gettext support disabled");
        return singularText;
    }

    public static synchronized String loc_tr(String text, Locale targetLocale) {
        Locale activeLocale = Translator.getLocale();
        Translator.setLocale(targetLocale);
        String result = Translator.tr(text);
        Translator.setLocale(activeLocale);
        return result;
    }

    public static synchronized String loc_tr(String text, Object value, Locale targetLocale) {
        Locale activeLocale = Translator.getLocale();
        Translator.setLocale(targetLocale);
        String result = Translator.tr(text, value);
        Translator.setLocale(activeLocale);
        return result;
    }

    public static synchronized String loc_tr(String text, List<Object> values, Locale targetLocale) {
        if (values != null) {
            return Translator.loc_tr(text, values.toArray(), targetLocale);
        }
        return Translator.loc_tr(text, new Object[0], targetLocale);
    }

    public static synchronized String loc_tr(String text, Object[] values, Locale targetLocale) {
        Locale activeLocale = Translator.getLocale();
        Translator.setLocale(targetLocale);
        String result = Translator.tr(text, values);
        Translator.setLocale(activeLocale);
        return result;
    }
}

