/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.report;

import de.effectivecompany.base.data.StatisticDataObject;
import de.effectivecompany.base.gui.swing.EFCLoginDialog;
import de.effectivecompany.base.report.AbstractDataProvider;
import de.effectivecompany.base.report.EfcStatisticDataSource;
import de.effectivecompany.base.report.query.ServiceQuery;
import de.effectivecompany.base.util.SpringHelper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.util.Collection;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class EfcServiceQueryExecuter
extends AbstractDataProvider
implements JRQueryExecuter {
    private static Logger logger = LoggerFactory.getLogger(EfcServiceQueryExecuter.class);
    private ServiceQuery query;
    private Object[] paramValues;
    private ResultFetcher rf;

    public EfcServiceQueryExecuter(ServiceQuery query, Object[] paramValues) {
        this.query = query;
        this.paramValues = paramValues;
    }

    public boolean cancelQuery() throws JRException {
        this.rf.interrupt();
        return true;
    }

    public void close() {
        this.rf = null;
        this.query = null;
        this.paramValues = null;
    }

    public JRDataSource createDatasource() throws JRException {
        logger.trace("EfcServiceQueryExecuter.createDatasource(): isServerContext: " + SpringHelper.isServerContext());
        if (!SpringHelper.isServerContext()) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (!auth.isAuthenticated()) {
                logger.trace("User is not logged in, so log him in.");
                SecurityContextHolder.setStrategyName((String)"MODE_GLOBAL");
                try {
                    Authentication authResult = null;
                    String lastUser = "";
                    String lastCompany = "";
                    while (authResult == null) {
                        Authentication request = EFCLoginDialog.getAuthentication(lastUser, lastCompany, null);
                        SecurityContext context = SecurityContextHolder.createEmptyContext();
                        context.setAuthentication(request);
                        try {
                            AuthenticationManager authenticationManager = (AuthenticationManager)SpringHelper.getBean("authenticationManager");
                            authResult = authenticationManager.authenticate(request);
                        }
                        catch (AuthenticationException e) {
                            authResult = null;
                            logger.error("AuthenticationException:" + e.getCause().getMessage());
                        }
                        catch (RemoteAccessException e) {
                            if (e.getCause() instanceof SocketException) {
                                JOptionPane.showMessageDialog(null, e.getCause().getMessage(), "Network Error", 0);
                                logger.error("RemoteAccessException:" + e.getCause().getMessage());
                            }
                            if (e.getCause() instanceof IOException) {
                                authResult = null;
                            }
                            logger.error("RemoteAccessException:" + e.getCause().getMessage());
                            throw e;
                        }
                        if (authResult == null || authResult.isAuthenticated()) continue;
                        authResult = null;
                    }
                }
                catch (RemoteAccessException rex) {
                    JOptionPane.showMessageDialog(null, rex.getMessage(), "Network Error", 0);
                    logger.error("RemoteAccessException:" + rex.getCause().getMessage());
                }
            }
            if (!(auth = SecurityContextHolder.getContext().getAuthentication()).isAuthenticated()) {
                logger.error("User could not be logged in!");
                throw new JRException("not authenticated");
            }
        }
        Object service = this.query.getService();
        Method method = this.query.getMethod();
        try {
            EfcStatisticDataSource datasrc;
            ResultFetcher rf = new ResultFetcher(method, service);
            rf.start();
            rf.join();
            if (rf.getError() != null) {
                throw rf.getError();
            }
            Object result = rf.getResult();
            logger.trace("got object of type: " + result.getClass().getName());
            if (result instanceof StatisticDataObject) {
                logger.trace("got statistic data");
                datasrc = new EfcStatisticDataSource((StatisticDataObject)result);
            } else if (result instanceof Collection) {
                logger.trace("number of rows found: " + ((Collection)result).size());
                datasrc = new JRBeanCollectionDataSource((Collection)result, false);
            } else {
                logger.trace("single object found");
                datasrc = new JRBeanArrayDataSource(new Object[]{result}, false);
            }
            return datasrc;
        }
        catch (InterruptedException ex) {
            logger.error("RemoteAccessException:" + ex.getCause().getMessage());
            return null;
        }
        catch (Throwable ex) {
            logger.error("RemoteAccessException:" + ex.getCause().getMessage());
            throw new JRException("error getting values", ex);
        }
    }

    private class ResultFetcher
    extends Thread {
        private Object result;
        private Method usedMethod;
        private Object usedTarget;
        private Throwable error;

        public ResultFetcher(Method method, Object target) {
            this.usedMethod = method;
            this.usedTarget = target;
        }

        @Override
        public void run() {
            try {
                this.result = this.usedMethod.invoke(this.usedTarget, EfcServiceQueryExecuter.this.paramValues);
            }
            catch (Throwable th) {
                th.printStackTrace();
                this.error = th;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public Throwable getError() {
            return this.error;
        }
    }
}

