/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.security;

import de.effectivecompany.base.datatypes.EFCPassword;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.EFCUserName;
import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class EFCUser
extends User {
    private static final long serialVersionUID = -5506894718731981244L;
    private String company = "";
    private EFCUserName efcUserName;

    public EFCUser(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, Collection<GrantedAuthority> authorities) throws IllegalArgumentException {
        super(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
        this.setEfcUserName(new EFCUserName(username));
    }

    public EFCUser(EFCUserName username, EFCString userpassw, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, Collection<GrantedAuthority> authorities) throws IllegalArgumentException {
        super(username.toString(), userpassw.toString(), enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
        this.setEfcUserName(username);
    }

    public EFCUser(EFCUserName username, EFCPassword userpassw, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, Collection<GrantedAuthority> authorities) throws IllegalArgumentException {
        super(username.toString(), userpassw.toString(), enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
        this.setEfcUserName(username);
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof EFCUser) || rhs == null) {
            return false;
        }
        User baseuser = (User)rhs;
        EFCUser base = this;
        if (!baseuser.equals((Object)base)) {
            return false;
        }
        EFCUser user = (EFCUser)((Object)rhs);
        return this.getEfcUserName().equals(user.getEfcUserName()) && this.getCompany().equals(user.getCompany());
    }

    public int hashCode() {
        return super.hashCode() + this.company.hashCode() + this.efcUserName.hashCode();
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getCompany() {
        return this.company;
    }

    public String toString() {
        return super.toString() + "; Company: " + this.company;
    }

    private void setEfcUserName(EFCUserName efcUserName) {
        this.efcUserName = efcUserName;
    }

    public EFCUserName getEfcUserName() {
        return this.efcUserName;
    }
}

