/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.util;

import de.effectivecompany.base.util.EDIFile;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class EDIFileReader
extends EDIFile {
    protected BufferedReader in;

    public EDIFileReader(String inputFileName) throws FileNotFoundException {
        this.in = new BufferedReader(new FileReader(inputFileName));
    }

    public EDIFileReader(String inputFileName, char sep) throws FileNotFoundException {
        super(sep);
        this.in = new BufferedReader(new FileReader(inputFileName));
    }

    public EDIFileReader(String inputFileName, char sep, char qual) throws FileNotFoundException {
        super(sep, qual);
        this.in = new BufferedReader(new FileReader(inputFileName));
    }

    public Vector<Vector<String>> readLines() throws IOException {
        Vector<Vector<String>> ediLines = new Vector<Vector<String>>();
        StringBuffer sb = new StringBuffer();
        String line = null;
        while ((line = this.in.readLine()) != null) {
            Vector<String> fields = new Vector<String>();
            if (line.length() == 0) {
                fields.add(line);
                ediLines.add(fields);
                return ediLines;
            }
            int i = 0;
            do {
                sb.setLength(0);
                if (i < line.length() && line.charAt(i) == this.textQualifier) {
                    ++i;
                    i = this.handleQuotedField(line, sb, i);
                } else {
                    i = this.handlePlainField(line, sb, i);
                }
                fields.add(sb.toString());
            } while (++i < line.length());
            ediLines.add(fields);
        }
        return ediLines;
    }

    public Vector<Vector<String>> readLinesWithoutSeperator() throws IOException {
        Vector<Vector<String>> ediLines = new Vector<Vector<String>>();
        String line = null;
        while ((line = this.in.readLine()) != null) {
            Vector<String> fields = new Vector<String>();
            if (line.length() == 0) {
                fields.add(line);
                ediLines.add(fields);
                return ediLines;
            }
            fields.add(line);
            ediLines.add(fields);
        }
        return ediLines;
    }

    public Vector<Vector<String>> readLinesWithoutSeperator(int rowLength) throws IOException {
        Vector<Vector<String>> ediLines = new Vector<Vector<String>>();
        char[] line = new char[rowLength];
        while (this.in.read(line, 0, rowLength) != -1) {
            Vector<String> fields = new Vector<String>();
            fields.add(new String(line));
            ediLines.add(fields);
            line = new char[rowLength];
        }
        return ediLines;
    }

    public void close() throws IOException {
        this.in.close();
    }

    protected int handleQuotedField(String s, StringBuffer sb, int i) {
        int j;
        int len = s.length();
        for (j = i; j < len; ++j) {
            if (s.charAt(j) == this.textQualifier && j + 1 < len) {
                if (s.charAt(j + 1) == this.textQualifier) {
                    ++j;
                } else if (s.charAt(j + 1) == this.fieldSeparator) {
                    ++j;
                    break;
                }
            } else if (s.charAt(j) == this.textQualifier && j + 1 == len) break;
            sb.append(s.charAt(j));
        }
        return j;
    }

    protected int handlePlainField(String s, StringBuffer sb, int i) {
        int j = s.indexOf(this.fieldSeparator, i);
        if (j == -1) {
            sb.append(s.substring(i));
            return s.length();
        }
        sb.append(s.substring(i, j));
        return j;
    }
}

